<?php

/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://woocommerce.com/document/template-structure/
 * @package    WooCommerce\Templates
 * @version    1.6.4
 */
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$englishName = get_post_meta(get_the_ID(), '_english_name', true);
$productTitle = trim(get_the_title());

$productTitleSeparated = null;
if (strpos($productTitle, ' ') !== false) {
    $productTitleExploded = array_filter(explode(' ', $productTitle));
    $productTitleSeparated = "<span>" . implode('</span> <span>', $productTitleExploded) . "</span>";
} else {
    $productTitleSeparated = "<span>{$productTitle}</span>";
}
?>
<h1 class="accountino-dual-heading__title">
    <span class="accountino-dual-heading__title1"><?= $productTitleSeparated; ?></span>
    <?php if (!empty($englishName)) { ?>
        <span class="accountino-dual-heading__title2"><?= $englishName; ?></span>
    <?php } ?>
</h1>