<?php

/**
 * The template to display the reviewers meta data (name, verified owner, review date)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review-meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */
defined('ABSPATH') || exit;

global $comment;
$verified = wc_review_is_from_verified_owner($comment->comment_ID);

$comment_author_id = $comment->user_id;

if ('0' === $comment->comment_approved) { ?>

	<p class="meta">
		<em class="woocommerce-review__awaiting-approval">
			<?php esc_html_e('Your review is awaiting approval', 'woocommerce'); ?>
		</em>
	</p>

<?php } else { ?>

	<p class="accountino-woocommerce-review__author">
		<?php comment_author(); ?>
	</p>
	<?php
	if ($comment_author_id) {
		$user = get_userdata($comment_author_id);

		if (!empty($user->roles)) {
			$role = $user->roles[0];
			echo '<p class="accountino-woocommerce-review__author_role">' . translateRole($role) . '</p>';
		}
	}
	?>
	<time class="accountino-comment-time woocommerce-review__published-date" datetime="<?php echo esc_attr(get_comment_date('c')); ?>"><?php echo esc_html(get_comment_date(wc_date_format())); ?></time>

<?php
}
