<?php

/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

use Automattic\WooCommerce\Enums\ProductType;

defined('ABSPATH') || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if (! function_exists('wc_get_gallery_image_html')) {
	return;
}

global $product;

$columns           = apply_filters('woocommerce_product_thumbnails_columns', 4);
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ($post_thumbnail_id ? 'with-images' : 'without-images'),
		'woocommerce-product-gallery--columns-' . absint($columns),
		'images',
	)
);
?>
<div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>" data-columns="<?php echo esc_attr($columns); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
	<div class="accountino-product-image">
		<div class="accountino-product-information accountino-buy-again">
			<p class="product-information__numbers">
				<span>%</span> <?= esc_html__(convert_to_persian_digits(get_post_meta(get_the_ID(), '_buy_again_percent', true))); ?>
			</p>
			<p>خرید دوباره از <?= esc_html__(convert_to_persian_digits(get_bloginfo('name'))); ?>!</p>
		</div>
		<div class="accountino-product-information accountino-satisfied-customers">
			<p class="product-information__numbers">
				<span>%</span> <?= esc_html__(convert_to_persian_digits(get_post_meta(get_the_ID(), '_satisfied_customers', true))); ?>
			</p>
			<p>مشتری رضایتمند!</p>
		</div>
		<div class="accountino-product-information accountino-last-month-activated">
			<p class="product-information__numbers">
				<span>+</span> <?= esc_html__(convert_to_persian_digits(get_post_meta(get_the_ID(), '_last_month_activate', true))); ?>
			</p>
			<p>فعالسازی در ماه گذشته!</p>
		</div>
		<div class="accountino-product-information accountino-license-numbers">
			<p class="product-information__numbers">
				<span>+</span> <?= esc_html__(convert_to_persian_digits(wp_count_posts('product')->publish)); ?>
			</p>
			<p>لایسنس و اشتراک مختلف!</p>
		</div>
	</div>
	<div class="woocommerce-product-gallery__wrapper accountino-single-product-image">
		<?php
		if ($post_thumbnail_id) {
			$html = wc_get_gallery_image_html($post_thumbnail_id, true);
		} else {
			$wrapper_classname = $product->is_type(ProductType::VARIABLE) && ! empty($product->get_available_variations('image')) ?
				'woocommerce-product-gallery__image woocommerce-product-gallery__image--placeholder' :
				'woocommerce-product-gallery__image--placeholder';
			$html              = sprintf('<div class="%s">', esc_attr($wrapper_classname));
			$html             .= sprintf('<img src="%s" alt="%s" class="wp-post-image" />', esc_url(wc_placeholder_img_src('woocommerce_single')), esc_html__('Awaiting product image', 'woocommerce'));
			$html             .= '</div>';
		}

		echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

		do_action('woocommerce_product_thumbnails');
		?>
	</div>
</div>