<?php

/**
 * Single variation cart button
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;
?>
<div class="woocommerce-variation-add-to-cart accountino-variation-add-to-cart variations_button">
	<?php do_action('woocommerce_before_add_to_cart_button'); ?>

	<?php
	do_action('woocommerce_before_add_to_cart_quantity');
	?>

	<div class="accountino-single-product-count">
		<label for="quantity"><?= esc_html__('تعداد:', 'accountino'); ?></label>
		<span class="quantity-wrapper">
			<button type="button" class="qty-plus">+</button>
			<input type="number" id="quantity" name="quantity" readonly class="input-text qty text" step="1" inputmode="numeric" min="<?= $product->get_min_purchase_quantity(); ?>" max="<?= $product->get_max_purchase_quantity(); ?>" name="quantity" value="<?= isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(); ?>" title="Qty" size="4" inputmode="numeric">
			<button type="button" class="qty-minus">-</button>
		</span>
	</div>
	<?php

	do_action('woocommerce_after_add_to_cart_quantity');
	?>

	<input type="hidden" name="add-to-cart" value="<?php echo absint($product->get_id()); ?>" />
	<input type="hidden" name="product_id" value="<?php echo absint($product->get_id()); ?>" />
	<input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>

<?php include(ACCOUNTINO_PATH . '/template-parts/shared/favorite.php'); ?>