<?php

/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;

if (! $product->is_purchasable()) {
	return;
}

echo wc_get_stock_html($product); // WPCS: XSS ok.

if ($product->is_in_stock()) : ?>

	<?php do_action('woocommerce_before_add_to_cart_form'); ?>

	<form class="cart" action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>" method="post" enctype='multipart/form-data'>
		<?php do_action('woocommerce_before_add_to_cart_button'); ?>

		<div class="accountino-single-product-cart">
			<div class="single_variation_wrap">
				<div class="woocommerce-variation">
					<div class="woocommerce-variation-price">
						<span>مبلغ قابل پرداخت:</span>
						<span class="accountino-single-product__price">
							<span class="price">
								<?= $product->get_price_html(); ?>
							</span>
						</span>
					</div>
				</div>
				<div class="accountino-single-product-count">
					<?php do_action('woocommerce_before_add_to_cart_quantity'); ?>
					<label for="quantity"><?= esc_html__('تعداد:', 'accountino'); ?></label>
					<span class="quantity-wrapper">
						<button type="button" class="qty-plus">+</button>
						<input type="number" id="quantity" name="quantity" readonly class="input-text qty text" step="1" inputmode="numeric" min="<?= $product->get_min_purchase_quantity(); ?>" min="<?= $product->get_max_purchase_quantity(); ?>" name="quantity" value="<?= isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(); ?>" title="Qty" size="4" inputmode="numeric">
						<button type="button" class="qty-minus">-</button>
					</span>
					<?php
					do_action('woocommerce_after_add_to_cart_quantity');
					?>
				</div>
				<?php include(ACCOUNTINO_PATH . '/template-parts/shared/favorite.php'); ?>

			</div>
			<div class="accountino-single-product-add-to-cart">
				<button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="accountino-fill-btn alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"><?php echo esc_html($product->single_add_to_cart_text()); ?></button>

				<?php do_action('woocommerce_after_add_to_cart_button'); ?>
			</div>
		</div>

	</form>

	<?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>