<?php

/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */
defined('ABSPATH') || exit;

global $product;

if (! comments_open()) {
	return;
}

?>

<div class="accountino-reviews-box" aria-labelledby="customer_reviews">
	<div id="reviews" class="woocommerce-Reviews border-shape-section">
		<div id="comments">
			<h2 class="woocommerce-Reviews-title accountino-dual-heading__title">
				<span class="accountino-dual-heading__title1">دیدگاه های شما</span>
				<span class="accountino-dual-heading__title2">Reviews</span>
			</h2>

			<?php if (have_comments()) : ?>
				<ol class="accountino-comment-list">
					<?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
				</ol>

				<?php
				if (get_comment_pages_count() > 1 && get_option('page_comments')) :
					echo '<nav class="woocommerce-pagination">';
					paginate_comments_links(
						apply_filters(
							'woocommerce_comment_pagination_args',
							array(
								'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
								'next_text' => is_rtl() ? '&larr;' : '&rarr;',
								'type'      => 'list',
							)
						)
					);
					echo '</nav>';
				endif;
				?>
			<?php else : ?>
				<p class="woocommerce-noreviews"><?php esc_html_e('There are no reviews yet.', 'woocommerce'); ?></p>
			<?php endif; ?>
		</div>

		<?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())) : ?>
			<div id="review_form_wrapper">
				<div class="accountino-review-form accountino-form" id="review_form">
					<h3 class="accountino-review-form__title">دیدگاه شما</h3>
					<p class="accountino-review-form__note">دیدگاه شما نه تنها به ما کمک می‌کنه خدمات بهتری ارائه بدیم، بلکه به دیگر کاربران هم در انتخابشون کمک می‌کنه.</p>
					<?php
					$commenter    = wp_get_current_commenter();
					$comment_form = array(
						/* translators: %s is product title */
						'title_reply'         => null,
						/* translators: %s is product title */
						'title_reply_to'      => esc_html__('Leave a Reply to %s', 'woocommerce'),
						'title_reply_before'  => '<span id="reply-title" class="comment-reply-title" role="heading" aria-level="3">',
						'title_reply_after'   => '</span>',
						'comment_notes_after' => '',
						'label_submit'        => 'ارسال دیدگاه',
						'class_submit'        => 'accountino-btn',
						'logged_in_as'        => '',
						'comment_field'       => '',
					);

					$name_email_required = (bool) get_option('require_name_email', 1);
					$fields              = array(
						'author' => array(
							'label'        => 'نام و نام خانوادگی شما:',
							'type'         => 'text',
							'value'        => $commenter['comment_author'],
							'required'     => $name_email_required,
							'autocomplete' => 'name',
						),
						'email'  => array(
							'label'        => 'ایمیل شما',
							'type'         => 'email',
							'value'        => $commenter['comment_author_email'],
							'required'     => $name_email_required,
							'autocomplete' => 'email',
						),
					);

					$comment_form['fields'] = array();

					foreach ($fields as $key => $field) {
						$field_html  = '<p class="comment-form-' . esc_attr($key) . '">';
						$field_html .= '<label for="' . esc_attr($key) . '">' . esc_html($field['label']);

						if ($field['required']) {
							$field_html .= '&nbsp;<span class="required">*</span>';
						}

						$field_html .= '</label><input id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" autocomplete="' . esc_attr($field['autocomplete']) . '" value="' . esc_attr($field['value']) . '" size="30" ' . ($field['required'] ? 'required' : '') . ' /></p>';

						$comment_form['fields'][$key] = $field_html;
					}

					$account_page_url = wc_get_page_permalink('myaccount');
					if ($account_page_url) {
						/* translators: %s opening and closing link tags respectively */
						$comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</p>';
					}

					$comment_form['comment_field'] = '<p class="comment-form-comment"><textarea id="comment" name="comment" placeholder="' . esc_html__('Your review', 'woocommerce') . '" cols="45" rows="8" required></textarea></p>';

					if (wc_review_ratings_enabled()) {
						$comment_form['comment_field'] .= '<div class="comment-form-rating"><label for="rating" id="comment-form-rating-label">امتیاز شما به ' . get_bloginfo('name') . ' ' . (wc_review_ratings_required() ? '&nbsp;<span class="required">*</span>' : '') . '</label><select name="rating" id="rating" required>
							<option value="">' . esc_html__('Rate&hellip;', 'woocommerce') . '</option>
							<option value="5">' . esc_html__('Perfect', 'woocommerce') . '</option>
							<option value="4">' . esc_html__('Good', 'woocommerce') . '</option>
							<option value="3">' . esc_html__('Average', 'woocommerce') . '</option>
							<option value="2">' . esc_html__('Not that bad', 'woocommerce') . '</option>
							<option value="1">' . esc_html__('Very poor', 'woocommerce') . '</option>
						</select></div>';
					}

					comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
					?>
				</div>
			</div>
		<?php else : ?>
			<p class="woocommerce-verification-required"><?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?></p>
		<?php endif; ?>

		<div class="clear"></div>
	</div>
	<div class="accountino-reviews-sidebar accountino-product-reviews-info">
		<div>
			<p>
				<span class="accountino-product-reviews-info__numbers"><i>%</i> <?= esc_html__(convert_to_persian_digits(get_post_meta(get_the_ID(), '_satisfied_customers', true))); ?></span>
				<span>مشتری رضایتمند!</span>
			</p>
			<img src="<?= ACCOUNTINO_ASSETS_URL; ?>images/customers.png" alt="">
		</div>
		<div>
			<p>
				<span class="accountino-product-reviews-info__numbers"><i>%</i> <?= esc_html__(convert_to_persian_digits(get_post_meta(get_the_ID(), '_buy_again_percent', true))); ?></span>
				<span>خرید دوباره از <?= esc_html__(convert_to_persian_digits(get_bloginfo('name'))); ?>!</span>
			</p>
			<img src="<?= ACCOUNTINO_ASSETS_URL; ?>images/rebuy.png" alt="">
		</div>
		<div>
			<p>
				<span class="accountino-product-reviews-info__numbers"><i>+</i> <?= esc_html__(convert_to_persian_digits(get_post_meta(get_the_ID(), '_last_month_activate', true))); ?></span>
				<span>فعالسازی در ماه گذشته!</span>
			</p>
			<img src="<?= ACCOUNTINO_ASSETS_URL; ?>images/cart.png" alt="">
		</div>
		<div>
			<p>
				<span class="accountino-product-reviews-info__numbers"><i>+</i> <?= esc_html__(convert_to_persian_digits(wp_count_posts('product')->publish)); ?></span>
				<span>لایسنس و اشتراک مختلف!</span>
			</p>
			<img src="<?= ACCOUNTINO_ASSETS_URL; ?>images/gift.png" alt="">
		</div>
	</div>
</div>