<?php

/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-customer.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.7.0
 */
defined('ABSPATH') || exit;

$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();

$customer = new WC_Customer($customer_id);
?>
<section class="woocommerce-customer-details">
	<div class="accountino-dt-content accountino-form">
		<div class="row">
			<div class="field-column column-4">
				<label>نام و نام خانوادگی
					<input type="text" readonly value="<?= $order->get_billing_first_name() . " " . $order->get_billing_last_name(); ?>">
				</label>
			</div>
			<div class="field-column column-4">
				<label>ایمیل
					<input type="text" readonly value="<?= $order->get_billing_email(); ?>">
				</label>
			</div>
			<div class="field-column column-4">
				<label>شماره همراه:
					<input type="text" readonly value="<?= $order->get_billing_phone(); ?>">
				</label>
			</div>
		</div>
		<?php
		do_action('woocommerce_order_details_after_customer_address', 'billing', $order);
		?>
	</div>

	<?php if ($show_shipping) : ?>
		<div class="accountino-dt-content accountino-form">
			<div class="row">
				<div class="field-column column-4">
					<label>نام و نام خانوادگی
						<input type="text" readonly value="<?= $order->get_shipping_first_name() . " " . $order->get_shipping_last_name(); ?>">
					</label>
				</div>
				<div class="field-column column-4">
					<label>ایمیل
						<input type="text" readonly value="<?= $order->get_shipping_email(); ?>">
					</label>
				</div>
				<div class="field-column column-4">
					<label>شماره همراه:
						<input type="text" readonly value="<?= $order->get_shipping_phone(); ?>">
					</label>
				</div>
			</div>
			<?php
			do_action('woocommerce_order_details_after_customer_address', 'shipping', $order);
			?>
		</div>

	<?php endif; ?>

	<?php do_action('woocommerce_order_details_after_customer_details', $order); ?>

</section>