<?php
$current_user_id = get_current_user_id();

$args = [
    'post_type'      => 'notification',
    'post_status'    => ['publish', 'private'],
    'posts_per_page' => $limit ?? 10,
];

$notifications = get_posts($args);

if (count($notifications) === 0) { ?>
    <div class="accountino-dashboard-comments-empty">
        <svg width="112" height="112" viewBox="0 0 112 112" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M83.3937 102.06C81.947 102.06 80.5004 101.686 79.1937 100.893L60.4804 89.7865C58.5204 89.7398 56.5604 89.5999 54.6937 89.3199C53.4337 89.1332 52.3603 88.293 51.8937 87.0797C51.427 85.8664 51.6604 84.5597 52.5004 83.5797C55.5804 79.9864 57.167 75.6931 57.167 71.1198C57.167 59.8265 47.227 50.6331 35.0004 50.6331C30.427 50.6331 26.0403 51.8932 22.3537 54.3199C21.327 54.9732 20.067 55.0665 18.947 54.5532C17.8737 54.0398 17.0804 53.0131 16.9404 51.7997C16.8004 50.4931 16.707 49.1865 16.707 47.8332C16.707 24.6865 36.7737 5.87988 61.4137 5.87988C86.0537 5.87988 106.12 24.6865 106.12 47.8332C106.12 60.5265 100.24 72.1931 89.8803 80.1731L91.4671 92.8666C91.8404 96.0399 90.4404 99.0266 87.7803 100.753C86.4737 101.593 84.9337 102.06 83.3937 102.06ZM61.367 82.7397C62.0203 82.6931 62.6737 82.88 63.2337 83.2533L82.7871 94.8732C83.3004 95.1999 83.7204 95.0599 84.0004 94.8732C84.2337 94.7332 84.607 94.3599 84.5137 93.7066L82.6937 78.9598C82.5537 77.6531 83.1137 76.3933 84.1404 75.6466C93.6604 68.9733 99.1204 58.7997 99.1204 47.7397C99.1204 28.4664 82.227 12.7865 61.4137 12.7865C41.3937 12.7865 24.967 27.3466 23.7537 45.64C27.2537 44.2866 31.0337 43.5399 34.9537 43.5399C51.0537 43.5399 64.1204 55.8597 64.1204 71.0264C64.1671 75.133 63.187 79.0997 61.367 82.7397Z" fill="#0EFDC2" />
            <path opacity="0.2" d="M21.3723 106.167C20.1589 106.167 18.9922 105.84 17.9189 105.14C15.8189 103.787 14.699 101.454 14.979 98.9802L15.9123 91.7934C9.61228 86.66 5.87891 79.0534 5.87891 71.0734C5.87891 61.9734 10.639 53.4801 18.619 48.3934C23.4256 45.2668 29.1189 43.5869 35.0456 43.5869C51.1456 43.5869 64.2122 55.9067 64.2122 71.0734C64.2122 77.2334 61.9722 83.3001 57.8656 88.1068C52.5922 94.5001 44.7056 98.2334 36.0256 98.5134L24.6389 105.28C23.6123 105.887 22.4923 106.167 21.3723 106.167ZM34.9989 50.5869C30.4256 50.5869 26.0389 51.8468 22.3522 54.2735C16.3789 58.1001 12.8323 64.3534 12.8323 71.0734C12.8323 77.56 16.0056 83.4869 21.6056 87.3136C22.679 88.0602 23.2389 89.32 23.0989 90.6267L22.0722 98.6068L33.2256 91.9802C33.7856 91.6536 34.3923 91.4667 34.9989 91.4667C41.8589 91.4667 48.3456 88.5269 52.4523 83.5336C55.5323 79.8936 57.1656 75.6 57.1656 71.0267C57.1656 59.78 47.2256 50.5869 34.9989 50.5869Z" fill="white" />
        </svg>
        اخبار و اطلاعیه ای ثبت نشده است.
    </div>
<?php
    return;
}

if ($notifications): ?>
    <div class="accountino-dashboard-notfications">
        <?php foreach ($notifications as $notification): ?>
            <div class="accountino-dn-item accountino-dct__message d-flex">
                <div class="accountino-dni__info accountino-dt-content">
                    <span>
                        <?php the_custom_logo(); ?>
                    </span>
                    <span>
                        <?= esc_html($notification->post_title); ?>
                    </span>
                    <span class="accountino-dni__date">
                        <svg width='13' height='14' viewBox='0 0 13 14' fill='none' xmlns='http://www.w3.org/2000/svg'>
                            <path fill-rule='evenodd' clip-rule='evenodd' d='M1.52727 2.8V12.4727H11.2V2.8H1.52727ZM0 2.54545C0 1.84255 0.569819 1.27273 1.27273 1.27273H11.4545C12.1575 1.27273 12.7273 1.84255 12.7273 2.54545V12.7273C12.7273 13.4302 12.1575 14 11.4545 14H1.27273C0.569819 14 0 13.4302 0 12.7273V2.54545Z' fill='#0EFDC2' />
                            <path fill-rule='evenodd' clip-rule='evenodd' d='M9.41818 0C9.83993 0 10.1818 0.341892 10.1818 0.763636V2.03636C10.1818 2.45811 9.83993 2.8 9.41818 2.8C8.99644 2.8 8.65454 2.45811 8.65454 2.03636V0.763636C8.65454 0.341892 8.99644 0 9.41818 0Z' fill='#0EFDC2' />
                            <path fill-rule='evenodd' clip-rule='evenodd' d='M3.30909 0C3.73084 0 4.07273 0.341892 4.07273 0.763636V2.03636C4.07273 2.45811 3.73084 2.8 3.30909 2.8C2.88735 2.8 2.54545 2.45811 2.54545 2.03636V0.763636C2.54545 0.341892 2.88735 0 3.30909 0Z' fill='#0EFDC2' />
                            <path fill-rule='evenodd' clip-rule='evenodd' d='M0 5.09091C0 4.66916 0.341892 4.32727 0.763636 4.32727H11.9636C12.3854 4.32727 12.7273 4.66916 12.7273 5.09091C12.7273 5.51265 12.3854 5.85455 11.9636 5.85455H0.763636C0.341892 5.85455 0 5.51265 0 5.09091Z' fill='#0EFDC2' />
                        </svg>
                        <?= get_the_date('', $notification); ?>
                    </span>
                </div>
                <div class="accountino-dni__text accountino-dt-content">
                    <?= wpautop(wp_kses_post($notification->post_content)); ?>
                </div>
            </div>
        <?php endforeach; ?>

    </div>
<?php endif; ?>