<?php

/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */
defined('ABSPATH') || exit;

$customer_id = get_current_user_id();

if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __('Billing address', 'woocommerce'),
			'shipping' => __('Shipping address', 'woocommerce'),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __('Billing address', 'woocommerce'),
		),
		$customer_id
	);
}

$customer = new WC_Customer($customer_id);
?>

<p>
	<?php echo apply_filters('woocommerce_my_account_my_address_description', esc_html__('The following addresses will be used on the checkout page by default.', 'woocommerce')); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
	?>
</p>

<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
	<div class="accountino-dashboard-address addresses">
	<?php endif; ?>

	<?php foreach ($get_addresses as $name => $address_title) : ?>
		<?php
		$address = wc_get_account_formatted_address($name);

		if ($name == 'billing') {
			$address1 = $customer->get_billing_address_1();
			$customerName = $customer->get_billing_first_name() . " " . $customer->get_billing_last_name();
			$zipCode = $customer->get_billing_postcode();
			$tel = $customer->get_billing_phone();
		} else {
			$address1 = $customer->get_shipping_address_1();
			$customerName = $customer->get_shipping_first_name() . " " . $customer->get_shipping_last_name();
			$zipCode = $customer->get_shipping_postcode();
			$tel = $customer->get_shipping_phone();
		}
		?>

		<div class="accountino-dashboard-address-item accountino-dt-content">
			<header class="d-flex justify-content-between align-items-center">
				<?php echo esc_html($address_title); ?>
				<a href="<?php echo esc_url(wc_get_endpoint_url('edit-address', $name)); ?>" class="accountino-fill-btn">
					<?php
					printf(
						/* translators: %s: Address title */
						$address ? "ویرایش آدرس" : "ثبت آدرس",
						esc_html($address_title)
					);
					?>
				</a>
			</header>
			<address>
				<?php if ($address) { ?>
					<img src="<?= ACCOUNTINO_IMAGES_URL; ?>map.png" alt="">
					<div>
						<p>
							<i class="fas fa-location-dot"></i>
							<?= $address1; ?>
						</p>
						<p>
							<i class="fas fa-user"></i>
							<?= $customerName; ?>
						</p>
						<p>
							<i class="fas fa-envelope"></i>
							<?= $zipCode; ?>
						</p>
						<p>
							<i class="fas fa-phone"></i>
							<?= $tel; ?>
						</p>
					</div>

				<?php } else {
					echo esc_html_e('You have not set up this type of address yet.', 'woocommerce');
				}
				?>
				<?php
				/**
				 * Used to output content after core address fields.
				 *
				 * @param string $name Address type.
				 * @since 8.7.0
				 */
				do_action('woocommerce_my_account_after_my_address', $name);
				?>
			</address>
		</div>

	<?php endforeach; ?>

	<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
	</div>
<?php
	endif;
