<?php

/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */
defined('ABSPATH') || exit;
global $wp;

$currentEndPoint = WC()->query->get_current_endpoint();

if (empty($currentEndPoint))
	$currentEndPoint = isset($wp->query_vars) ? $wp->query_vars : null;

$currentPageTitle = Accountino_Woocommerce_Account::getCurrentPageTitle($currentEndPoint);
?>
<div class="d-flex e-con e-flex">
	<div class="e-con-inner">
		<div class="accountino-dashboard-container">
			<div class="accountino-dashboard-sidebar">
				<?php do_action('woocommerce_account_navigation'); ?>
			</div>

			<div class="accountino-dashboard-content">
				<?php if (!empty($currentPageTitle)) { ?>
					<h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
						<span class="accountino-dual-heading__title1"><?= getTextWordByWord($currentPageTitle); ?></span>
					</h2>
				<?php } ?>
				<?php
				/**
				 * My Account content.
				 *
				 * @since 2.6.0
				 */
				do_action('woocommerce_account_content');
				?>
			</div>
		</div>
	</div>
</div>