<?php

$current_user = wp_get_current_user();
$customer_orders = wc_get_orders([
    'customer_id' => get_current_user_id(),
    'limit'       => -1,
]);
?>
<div class="accountino-dashboard-licenses">

    <?php
    if ($customer_orders) : ?>
        <?php
        foreach ($customer_orders as $order) {
            foreach ($order->get_items() as $item) {
                $product = $item->get_product();
                $product_id = $product->get_id();
                $order_date = $order->get_date_created()->date('Y/m/d');

                $orderMeta = Accountino_Woocommerce_Account::getOrderMetaData($item);

                $durationTime = Accountino_Woocommerce_Account::getOrderItemTimeDuration($orderMeta, $order_date); ?>
                <div class="accountino-dashboard-licenses-item d-flex accountino-form">
                    <div class="accountino-dli__image">
                        <div class="accountino-dlii__shapes">
                            <span></span>
                            <span></span>
                        </div>
                        <div class="accountino-dlii__image">
                            <?php echo $product->get_image(); ?>
                        </div>
                        <div class="accountino-dlii__main">
                        </div>
                        <div class="accountino-dlii__circle"></div>
                    </div>
                    <div class="accountino-dli__content">
                        <div class="row accountino-dlic__title">
                            <?php echo esc_html($product->get_name()); ?>
                            <?php if (!empty($durationTime['daysLeft'])) { ?>
                                <span class="days-left"><?= $durationTime['daysLeft']; ?> روز باقی مانده</span>
                            <?php } ?>
                        </div>
                        <div class="row">
                            <div class="field-column column-6">
                                <label>
                                    نام و نام‌خانوادگی کاربر:
                                    <input type="text" readonly value="<?php echo esc_html($current_user->display_name); ?>">
                                </label>
                            </div>
                            <div class="field-column column-6">
                                <label>
                                    ایمیل:
                                    <input type="text" readonly value="<?php echo esc_html($current_user->user_email); ?>">
                                </label>
                            </div>
                        </div>
                        <?php
                        $counter = 0;
                        $total = count($orderMeta);
                        foreach ($orderMeta as $meta) {
                            if ($counter % 2 == 0)
                                echo "<div class='row'>";

                            echo "<div class='field-column column-6'>
                                        <label>
                                            {$meta['label']}
                                            <input type='text' readonly value='{$meta['formatted_value']}'>
                                        </label>
                                    </div>";

                            if ($counter % 2 == 1 || $counter === count($orderMeta) - 1)
                                echo "</div>";

                            $counter++;
                        }
                        ?>

                        <div class="row">
                            <div class="field-column column-6">
                                <label>
                                    تاریخ خرید:
                                    <input type="text" readonly value="<?php echo get_the_date($order_date); ?>">
                                </label>
                            </div>
                            <div class="field-column column-6">
                                <label>
                                    تاریخ انقضا:
                                    <input type="text" readonly value="<?php echo !empty($durationTime['expireDate']) ? get_the_date($durationTime['expireDate']) : '-'; ?>">
                                </label>
                            </div>
                        </div>
                        <div class="row justify-content-end mb-0">
                            <a class="accountino-btn" href="<?php echo esc_url(wc_get_account_endpoint_url('contact_support')); ?>">ارتباط با پشتیبانی</a>
                            <a class="accountino-fill-btn" href="<?= get_the_permalink($product_id); ?>">تمدید اشتراک</a>
                        </div>
                    </div>
                </div>
    <?php
            }
        }
    else :
        echo '<p>هیچ سفارشی یافت نشد.</p>';
    endif;
    ?>

</div>