<?php

/**
 * Edit address form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */
defined('ABSPATH') || exit;

$page_title = ('billing' === $load_address) ? esc_html__('Billing address', 'woocommerce') : esc_html__('Shipping address', 'woocommerce');

do_action('woocommerce_before_edit_account_address_form'); ?>

<style>
	.accountino-dashboard-content>.accountino-dashboard__page_title {
		display: none;
	}
</style>

<?php if (! $load_address) : ?>
	<?php wc_get_template('myaccount/my-address.php'); ?>
<?php else :
	$pageTitle = apply_filters('woocommerce_my_account_edit_address_title', $page_title, $load_address);
?>
	<form method="post" class="accountino-form" novalidate>

		<h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
			<span class="accountino-dual-heading__title1"><?= getTextWordByWord($pageTitle); ?></span>
		</h2>

		<div class="woocommerce-address-fields">
			<?php do_action("woocommerce_before_edit_address_form_{$load_address}"); ?>

			<div class="woocommerce-address-fields__field-wrapper">
				<?php
				$counter = 0;
				$total = count($address);
				foreach ($address as $key => $field) {
					if ($counter % 2 == 0)
						echo "<div class='row'>";

					echo '<div class="field-column column-6">';
					woocommerce_form_field($key, $field, wc_get_post_data_by_key($key, $field['value']));
					echo '</div>';

					if ($counter % 2 == 1 || $counter === count($address))
						echo "</div>";

					$counter++;
				}
				?>
			</div>

			<?php do_action("woocommerce_after_edit_address_form_{$load_address}"); ?>

			<div class="row justify-content-end">
				<button type="submit" class="accountino-fill-btn" name="save_address" value="<?php esc_attr_e('Save address', 'woocommerce'); ?>"><?php esc_html_e('Save address', 'woocommerce'); ?></button>
				<?php wp_nonce_field('woocommerce-edit_address', 'woocommerce-edit-address-nonce'); ?>
				<input type="hidden" name="action" value="edit_address" />
			</div>
		</div>

	</form>

<?php endif; ?>

<?php do_action('woocommerce_after_edit_account_address_form'); ?>