<?php
defined('ABSPATH') || exit;

$favoriteQuery = Accountino_Post_Service::favoritePosts(['post_type' => 'product']);

if ($favoriteQuery->have_posts()) {
?>
    <div class="d-flex justify-content-between align-items-start">
        <h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
            <span class="accountino-dual-heading__title1"><?= getTextWordByWord('محصولات مورد علاقه'); ?></span>
        </h2>
        <a href="<?php echo esc_url(wc_get_endpoint_url('favorites')); ?>" class="accountino-btn">بازگشت به صفحه قبل</a>
    </div>
    <?php
    woocommerce_product_loop_start(); // Opens the <ul class="products">

    while ($favoriteQuery->have_posts()) {

        $favoriteQuery->the_post();
        $postType = get_post_type(get_the_ID());

        wc_get_template_part('content', 'product');
    }

    woocommerce_product_loop_end(); // Closes the <ul class="products">
} else {
    ?>
    <div class="accountino-dashboard-empty">
        <svg width="113" height="112" viewBox="0 0 113 112" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path opacity="0.2" d="M71.7132 103.833H41.2866C18.3732 103.833 8.57324 94.0333 8.57324 71.12V70.5133C8.57324 49.7933 16.7399 39.8066 35.0332 38.08C36.8999 37.94 38.6732 39.34 38.8599 41.2533C39.0466 43.1666 37.6466 44.8933 35.6866 45.08C21.0332 46.4333 15.5732 53.34 15.5732 70.56V71.1666C15.5732 90.16 22.2932 96.88 41.2866 96.88H71.7132C90.7066 96.88 97.4266 90.16 97.4266 71.1666V70.56C97.4266 53.2466 91.8732 46.34 76.9399 45.08C75.0266 44.8933 73.5799 43.2133 73.7666 41.3C73.9532 39.3866 75.5866 37.94 77.5466 38.1266C96.1199 39.7133 104.427 49.7466 104.427 70.6066V71.2133C104.427 94.0333 94.6266 103.833 71.7132 103.833Z" fill="white" />
            <path d="M56.5 72.94C54.5867 72.94 53 71.3534 53 69.44V9.33337C53 7.42004 54.5867 5.83337 56.5 5.83337C58.4133 5.83337 60 7.42004 60 9.33337V69.44C60 71.4 58.4133 72.94 56.5 72.94Z" fill="#0EFDC2" />
            <path d="M56.4996 78.1667C55.6129 78.1667 54.7263 77.84 54.0263 77.14L38.3929 61.5067C37.0396 60.1534 37.0396 57.9134 38.3929 56.56C39.7463 55.2067 41.9863 55.2067 43.3396 56.56L56.4996 69.72L69.6596 56.56C71.0129 55.2067 73.2529 55.2067 74.6063 56.56C75.9596 57.9134 75.9596 60.1534 74.6063 61.5067L58.9729 77.14C58.2729 77.84 57.3863 78.1667 56.4996 78.1667Z" fill="#0EFDC2" />
        </svg>

        شما هنوز علاقه مندی ای ثبت نکرده اید.
    </div>
<?php
}

wp_reset_postdata();

?>