<?php
defined('ABSPATH') || exit;

$favoriteProductQuery = Accountino_Post_Service::favoritePosts(['posts_per_page' => 3, 'post_type' => 'product']);
$favoritePostQuery = Accountino_Post_Service::favoritePosts(['posts_per_page' => 3, 'post_type' => 'post']);

if (!$favoriteProductQuery->have_posts() && !$favoritePostQuery->have_posts()) {
?>
    <div class="accountino-dashboard-empty">
        <svg width="112" height="112" viewBox="0 0 112 112" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M55.9997 101.033C54.553 101.033 53.153 100.847 51.9863 100.427C34.1597 94.3132 5.83301 72.6132 5.83301 40.5532C5.83301 24.2199 19.0397 10.9666 35.2797 10.9666C43.1663 10.9666 50.5397 14.0466 55.9997 19.5532C61.4597 14.0466 68.833 10.9666 76.7197 10.9666C92.9597 10.9666 106.166 24.2666 106.166 40.5532C106.166 72.6599 77.8397 94.3132 60.013 100.427C58.8463 100.847 57.4463 101.033 55.9997 101.033ZM35.2797 17.9666C22.913 17.9666 12.833 28.0932 12.833 40.5532C12.833 72.4266 43.493 90.1599 54.273 93.8466C55.113 94.1266 56.933 94.1266 57.773 93.8466C68.5063 90.1599 99.213 72.4732 99.213 40.5532C99.213 28.0932 89.133 17.9666 76.7663 17.9666C69.673 17.9666 63.093 21.2799 58.8463 27.0199C57.5397 28.7932 54.553 28.7932 53.2463 27.0199C48.9063 21.2332 42.373 17.9666 35.2797 17.9666Z" fill="#0EFDC2" />
        </svg>


        شما هنوز علاقه مندی ای ثبت نکرده اید.
    </div>
<?php
    return;
}
?>

<div class="accountino-dashboard-mini-favorite__products border-shape-section">
    <h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
        <span class="accountino-dual-heading__title1"><?= getTextWordByWord('اشتراک و لایسنس ها'); ?></span>
    </h2>
    <a href="<?php echo esc_url(wc_get_endpoint_url('favorite-products')); ?>" class="link-arrow"></a>

    <div class="accountino-dmfpr__list">
        <?php

        if ($favoriteProductQuery->have_posts()) {
            woocommerce_product_loop_start(); // Opens the <ul class="products">

            while ($favoriteProductQuery->have_posts()) {
                $favoriteProductQuery->the_post();
                wc_get_template_part('content', 'product');
            }

            woocommerce_product_loop_end(); // Closes the <ul class="products">
        }

        wp_reset_postdata();

        ?>
    </div>
</div>

<div class="accountino-dashboard-mini-favorite__posts border-shape-section">
    <h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
        <span class="accountino-dual-heading__title1"><?= getTextWordByWord('وبلاگ'); ?></span>
    </h2>
    <a href="<?php echo esc_url(wc_get_endpoint_url('favorite-posts')); ?>" class="link-arrow"></a>

    <div class="accountino-dmfps__list accountino-blog accountino-blog-grid">
        <?php

        while ($favoritePostQuery->have_posts()) {
            $favoritePostQuery->the_post();
            echo Accountino_Post_Category_Service::generatePost($post);
        }

        wp_reset_postdata();

        ?>
    </div>
</div>