<?php
$current_user = wp_get_current_user();
$customer_orders = wc_get_orders([
    'customer_id' => get_current_user_id(),
    'limit'       => 2,
]);
?>
<div class="accountino-dashboard-mini-licenses border-shape-section">
    <h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
        <span class="accountino-dual-heading__title1"><?= getTextWordByWord('وضعیت اشتراک و لایسنس ها'); ?></span>
    </h2>
    <a href="<?php echo esc_url(wc_get_endpoint_url('licenses')); ?>" class="link-arrow"></a>
    <?php
    if ($customer_orders) : ?>
        <?php
        foreach ($customer_orders as $order) {
            foreach ($order->get_items() as $item) {
                $product = $item->get_product();
                $product_id = $product->get_id();
                $order_date = $order->get_date_created()->date('Y/m/d');

                $orderMeta = Accountino_Woocommerce_Account::getOrderMetaData($item);

                $durationTime = Accountino_Woocommerce_Account::getOrderItemTimeDuration($orderMeta, $order_date); ?>
                <div class="accountino-dashboard-mini-licenses-item d-flex">
                    <div class="accountino-dmli__image">
                        <div class="accountino-dmlii__image">
                            <img src="<?= ACCOUNTINO_CORE_ASSETS_URL; ?>images/medal.png" alt="Medal">
                        </div>
                        <div class="accountino-dmlii__product_name">
                            <?php echo esc_html($product->get_name()); ?>
                        </div>
                    </div>
                    <div class="accountino-dmli__content">
                        <div class="accountino-dlic__title">
                            <?php if (!empty($durationTime['daysLeft'])) { ?>
                                <span class="days-left"><?= $durationTime['daysLeft']; ?> روز باقی مانده</span>
                            <?php } ?>
                        </div>
                        <ul>
                            <li>
                                <i class="accountino-bullet"></i>
                                <span>تاریخ خرید:</span>
                                <?php echo get_the_date($order_date); ?>
                            </li>
                            <li>
                                <i class="accountino-bullet"></i>
                                <span>تاریخ پایان:</span>
                                <?php echo !empty($durationTime['expireDate']) ? get_the_date($durationTime['expireDate']) : '-'; ?>
                            </li>
                            <li>
                                <i class="accountino-bullet"></i>
                                <span>هزینه:</span>
                                <?php echo $item->get_total(); ?>
                            </li>
                        </ul>
                    </div>
                </div>
    <?php
            }
        }
    else :
        echo '<p>هیچ سفارشی یافت نشد.</p>';
    endif;
    ?>

</div>