<?php

$args = [
    'post_type'      => 'support_ticket',
    'author'         => get_current_user_id(),
    'post_status'    => ['publish', 'private'],
    'posts_per_page' => -1,
];

$tickets = get_posts($args);

$statuses = [
    'open' => 0,
    'pending' => 0,
    'closed' => 0
];
if ($tickets) {
    foreach ($tickets as $ticket) {
        $status = Accountino_Woocommerce_Account_Ticketing::getTicketStatus($ticket->ID, false);
        $statuses[$status]++;
    }
}

?>
<div class="accountino-dashboard-mini-contact_support border-shape-section">
    <h2 class="accountino-dual-heading__title accountino-dashboard__page_title">
        <span class="accountino-dual-heading__title1"><?= getTextWordByWord('تماس با پشتیبانی'); ?></span>
    </h2>
    <a href="<?php echo esc_url(wc_get_endpoint_url('contact_support')); ?>" class="link-arrow"></a>
    <ul class="accountino-dmcs__items">
        <li>
            <div class="d-flex">
                <i class="fas fa-comments"></i>
                <p class="mb-0">
                    همه:<br>
                    <span class="accountino-dmcs_english">All</span>
                </p>
            </div>
            <span class="accountino-dmcs_value">
                <?= convert_to_persian_digits(count($tickets)); ?>
            </span>
        </li>
        <li>
            <div class="d-flex">
                <i class="fas fa-rotate"></i>
                <p class="mb-0">
                    منتظر پاسخ:<br>
                    <span class="accountino-dmcs_english">Waiting</span>
                </p>
            </div>
            <span class="accountino-dmcs_value">
                <?= convert_to_persian_digits($statuses['pending']); ?>
            </span>
        </li>
        <li>
            <div class="d-flex">
                <i class="fas fa-times"></i>
                <p class="mb-0">
                    درحال بررسی:<br>
                    <span class="accountino-dmcs_english">Under Reviews</span>
                </p>
            </div>
            <span class="accountino-dmcs_value">
                <?= convert_to_persian_digits($statuses['open']); ?>
            </span>
        </li>
        <li>
            <div class="d-flex">
                <i class="fas fa-check"></i>
                <p class="mb-0">
                    پایان یافته:<br>
                    <span class="accountino-dmcs_english">Finished</span>
                </p>
            </div>
            <span class="accountino-dmcs_value">
                <?= convert_to_persian_digits($statuses['closed']); ?>
            </span>
        </li>
    </ul>

</div>