<?php
$ticket_id = absint($_GET['id']);
$post = get_post($ticket_id);

$department = get_post_meta($ticket_id, '_ticket_department', true);
$departmentText = !empty($department) ? Accountino_Woocommerce_Account_Ticketing::DEPARTMENTS[$department] : null;

$priority = get_post_meta($ticket_id, '_ticket_priority', true);
$priorityText = !empty($priority) ? Accountino_Woocommerce_Account_Ticketing::PRIORITY[$priority] : null;

$ticketAuthor = $post->post_author;

$statusText = Accountino_Woocommerce_Account_Ticketing::getTicketStatus($ticket_id);
?>
<div class="accountino-dashbaord-tickets">
    <div class="accountino-dt-top accountino-dct-top d-flex justify-content-between">
        <span class="accountino-dct-top__status">وضعیت: <?= $statusText; ?></span>
        <a href="" class="accountino-btn">بازگشت به صفحه قبل</a>
    </div>
    <div class="accountino-dt-content">
        <a class="accountino-dt-content__delete accountino-btn">
            <i class="fa fa-trash-can"></i>
        </a>
        <div class="accountino-dt-content__text accountino-dt-first-ticket">
            <?= wpautop(wp_kses_post($post->post_content)); ?>
        </div>
        <div class="accountino-dt-content__meta d-flex">
            <span><i class="fas fa-circle"></i> <?= get_the_date('', $ticket_id); ?></span>
            <span><i class="fas fa-circle"></i> اولویت: <?= $priorityText; ?></span>
            <span><i class="fas fa-circle"></i> دپارتمان: <?= $departmentText; ?></span>
            <span><i class="fas fa-circle"></i> سفارش: <?= get_post_meta($ticket_id, '_ticket_order_no', true); ?></span>
            <span><i class="fas fa-circle"></i> <?= get_post_meta($ticket_id, '_ticket_product_name', true); ?></span>
        </div>
    </div>

    <div class="accountino-dt-replies">
        <?php
        $comments = get_comments(['post_id' => $ticket_id, 'order' => 'ASC']);
        if ($comments) {
            echo '<ul class="accountino-dt-replies-list">';
            foreach ($comments as $comment) {
                $author = $comment->user_id;
                if ($author === $ticketAuthor) { // Means Question
                    $commentAlign = 'start';
                } else { // Means Answer
                    $commentAlign = 'end';
                }

                $commentContent = trim($comment->comment_content);

                echo "<li class='accountino-dt-content align-self-{$commentAlign}'>
                    <span class='accountino-dt-content__text'>{$commentContent}</span>
                    <span class='accountino-dt-content__meta'>" . get_comment_date('Y.m.d', $comment) . " <i class='fas fa-circle'></i></span>
                </li>";
            }
            echo '</ul>';
        }

        $lastComment = end($comments);

        // Reply Form
        if ($lastComment->user_id != $ticketAuthor) { ?>
            <div class="accountino-dt-reply accountino-form accountino-dt-content">

                <?php
                comment_form([
                    'title_reply' => '',
                    'comment_notes_after' => '',
                    'label_submit' => 'ارسال پیام',
                    'comment_field' => '<textarea name="comment" placeholder="پاسخ شما" rows="4" required></textarea>',
                    'submit_button'        => '<button name="%1$s" type="submit" id="%2$s" class="%3$s align-self-end">%4$s</button>',
                ], $ticket_id);

                ?>
            </div>
        <?php } ?>

    </div>
</div>
<?php
wp_reset_postdata();
