<?php
$args = [
    'post_type'      => 'support_ticket',
    'author'         => get_current_user_id(),
    'post_status'    => ['publish', 'private'],
    'posts_per_page' => -1,
];

$tickets = get_posts($args);

$statuses = [
    'open' => 0,
    'pending' => 0,
    'closed' => 0
];
if ($tickets) {
    foreach ($tickets as $ticket) {
        $status = Accountino_Woocommerce_Account_Ticketing::getTicketStatus($ticket->ID, false);
        $statuses[$status]++;
    }
}

?>

<div class="d-flex justify-content-between accountino-tickets-filter">
    <ul class="accountino-filter-buttons">
        <li>
            <button type="button" class="active">همه <span><?= convert_to_persian_digits(count($tickets)); ?></span></button>
        </li>
        <li>
            <button type="button" data-status="pending">منتظر پاسخ <span><?= convert_to_persian_digits($statuses['pending']); ?></span></button>
        </li>
        <li>
            <button type="button" data-status="open">درحال بررسی <span><?= convert_to_persian_digits($statuses['open']); ?></span></button>
        </li>
        <li>
            <button type="button" data-status="closed">پایان یافته <span><?= convert_to_persian_digits($statuses['closed']); ?></span></button>
        </li>
    </ul>
    <a href="<?= esc_url(add_query_arg('new', '1')); ?>" class="accountino-fill-btn">ارتباط با پشتیبانی</a>

    <script>
        jQuery(document).ready(function($) {
            $('.accountino-filter-buttons button').click(function() {
                $('.accountino-filter-buttons button').removeClass('active');
                $('.account-tickets-table tr').show();
                if (this.dataset.status) {
                    $(`.account-tickets-table tbody tr:not([data-status="${this.dataset.status}"])`).hide();
                }

                $(this).addClass('active');
            })
        })
    </script>
</div>