<?php

defined('ABSPATH') || exit;

$userComments = Accountino_Woocommerce_Product::getUserComments();
if (count($userComments) === 0) { ?>
    <div class="accountino-dashboard-empty">
        <svg width="112" height="112" viewBox="0 0 112 112" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M55.9997 106.447C52.7797 106.447 49.7463 104.813 47.5997 101.967L40.5997 92.6334C40.4597 92.4467 39.8997 92.2134 39.6663 92.1667H37.333C17.873 92.1667 5.83301 86.8934 5.83301 60.6667V37.3334C5.83301 16.7067 16.7063 5.83337 37.333 5.83337H74.6663C95.293 5.83337 106.166 16.7067 106.166 37.3334V60.6667C106.166 81.2934 95.293 92.1667 74.6663 92.1667H72.333C71.9597 92.1667 71.633 92.3534 71.3997 92.6334L64.3997 101.967C62.253 104.813 59.2197 106.447 55.9997 106.447ZM37.333 12.8334C20.6263 12.8334 12.833 20.6267 12.833 37.3334V60.6667C12.833 81.76 20.0663 85.1667 37.333 85.1667H39.6663C42.0463 85.1667 44.753 86.52 46.1997 88.4334L53.1997 97.7667C54.833 99.9134 57.1663 99.9134 58.7997 97.7667L65.7997 88.4334C67.3397 86.38 69.7663 85.1667 72.333 85.1667H74.6663C91.373 85.1667 99.1664 77.3734 99.1664 60.6667V37.3334C99.1664 20.6267 91.373 12.8334 74.6663 12.8334H37.333Z" fill="#0EFDC2" />
            <path opacity="0.2" d="M55.9997 56C53.3863 56 51.333 53.9 51.333 51.3333C51.333 48.7666 53.433 46.6666 55.9997 46.6666C58.5663 46.6666 60.6663 48.7666 60.6663 51.3333C60.6663 53.9 58.613 56 55.9997 56Z" fill="white" />
            <path opacity="0.2" d="M74.6667 56C72.0533 56 70 53.9 70 51.3333C70 48.7666 72.1 46.6666 74.6667 46.6666C77.2333 46.6666 79.3333 48.7666 79.3333 51.3333C79.3333 53.9 77.28 56 74.6667 56Z" fill="white" />
            <path opacity="0.2" d="M37.3337 56C34.7203 56 32.667 53.9 32.667 51.3333C32.667 48.7666 34.767 46.6666 37.3337 46.6666C39.9003 46.6666 42.0003 48.7666 42.0003 51.3333C42.0003 53.9 39.947 56 37.3337 56Z" fill="white" />
        </svg>
        شما هنوز دیدگاهی ثبت نکردید
    </div>
<?php
    return;
}
?>
<div class="accountino-dashboard-comments">
    <?php foreach ($userComments as $comment) {
        $productId = $comment->comment_post_ID;
        $productData = wc_get_product($productId);
        if (empty($productData)) continue;
        $productImage = wp_get_attachment_image_src(get_post_thumbnail_id($productId), 'single-post-thumbnail');

        $statusText = ($comment->comment_approved == 1 ? '<i class="fa fa-check status-approved"></i> تایید شده' : '<i class="status-pending">!</i> درحال بررسی');
        $rating = get_comment_meta($comment->comment_ID, 'rating', true);
    ?>
        <div class="accountino-dashboard-comments-items">
            <div class="accountino-dashboard-comments-info">
                <?= !empty($productImage[0]) ? "<img src='{$productImage[0]}' class='accountino-dci__image' />" : ''; ?>
                <p class="accountino-dci__name">
                    <?= get_the_title($productId); ?>
                </p>
                <p class="accountino-dci__date">
                    <?= get_comment_date('Y.m.d', $comment); ?>
                </p>
            </div>
            <div class="accountino-dashboard-comments-text">
                <div>
                    <div class="accountino-dct-top">
                        <span class="accountino-dct-top__status">
                            <?= $statusText; ?>
                        </span>
                        <span onclick="deleteComment(<?= $comment->comment_ID; ?>)" class="accountino-dct-top__remove">
                            <i class="fa fa-trash-can"></i>
                        </span>
                    </div>
                    <div class="accountino-dct__message">
                        <?= $comment->comment_content; ?>
                    </div>
                    <div class="accountino-dct__rating">
                        <?= wc_get_rating_html($rating); ?>
                    </div>
                </div>
                <a href="<?= get_the_permalink($productId); ?>#reviews" class="accountino-dct__link">مشاهده پاسخ ها</a>
            </div>
        </div>
    <?php } ?>
</div>


<script>
    function deleteComment(commentId) {
        if (!confirm('برای حذف دیدگاه مطئنید؟'))
            return;
        jQuery.post(ajaxUrl, {
            action: 'accountino_delete_comment',
            user_id: '<?= get_current_user_id(); ?>',
            comment_id: commentId,
        }, function(response) {
            if (response?.success) {
                location.reload();
            } else {
                alert('مشکلی پیش آمده است!');
            }

        });

    }
</script>
</div>