<?php

/**
 * Show options for ordering
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/orderby.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.7.0
 */

if (! defined('ABSPATH')) {
	exit;
}

$id_suffix = wp_unique_id();

?>
<form class="woocommerce-ordering accountino-woo-ordering" method="get">
	<label for="woocommerce-orderby-<?php echo esc_attr($id_suffix); ?>"><?php echo esc_html__('مرتب سازی:', 'woocommerce'); ?></label>
	<div>
		<?php
		foreach ($catalog_orderby_options as $id => $name) : ?>
			<button type="button" class="accountino-btn <?= $orderby === $id ? 'active' : ''; ?>" onclick="jQuery(this).parent().find('select').val(this.value).trigger('change')" value="<?= esc_attr($id); ?>"><?= esc_html__($name); ?></button>
		<?php endforeach; ?>

		<select
			name="orderby"
			class="orderby"
			style="display: none;"
			<?php if ($use_label) : ?>
			id="woocommerce-orderby-<?php echo esc_attr($id_suffix); ?>"
			<?php else : ?>
			aria-label="<?php esc_attr_e('Shop order', 'woocommerce'); ?>"
			<?php endif; ?>>
			<?php foreach ($catalog_orderby_options as $id => $name) : ?>
				<option value="<?php echo esc_attr($id); ?>" <?php selected($orderby, $id); ?>><?php echo esc_html($name); ?></option>
			<?php endforeach; ?>
		</select>
		<input type="hidden" name="paged" value="1" />
		<?php wc_query_string_form_fields(null, array('orderby', 'submit', 'paged', 'product-page')); ?>
	</div>
</form>