<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if (! is_a($product, WC_Product::class) || ! $product->is_visible()) {
	return;
}

$isFavoritePage = is_account_page() || isset($wp->query_vars['favorite-products']);

if ($isFavoritePage) {
	$checkIsFavorite = Accountino_Post_Service::checkPostIsFavorite($product->get_id());
	$favoriteHtml = '<span class="card-favorite-btn" onclick="favoritePost(' . $product->get_id() . '); return false;">
        <i class="fa' . (!$checkIsFavorite ? 'r' : 's') . ' fa-heart" data-id="' . $product->get_id() . '" data-favorite="' . ($checkIsFavorite ? "true" : "false") . '"></i>
    </span>';
} else {
	$favoriteHtml = null;
}
?>

<li <?php wc_product_class('product-box', $product); ?>>
	<?php
	/**
	 * Hook: woocommerce_before_shop_loop_item.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10
	 */
	do_action('woocommerce_before_shop_loop_item');

	/**
	 * Hook: woocommerce_before_shop_loop_item_title.
	 *
	 * @hooked woocommerce_show_product_loop_sale_flash - 10
	 * @hooked woocommerce_template_loop_product_thumbnail - 10
	 */

	$region = get_post_meta($post->ID, '_product_region', true);
	$region = (!empty($region) ? esc_html__(mb_substr(strip_tags($region), 0, 15)) : null);

	echo "<div class='product-box-top'>"; ?>
	<?php
	do_action('woocommerce_before_shop_loop_item_title');
	echo "<div class='product-box-top__shapes'>
			<span class='product-box-top__right'></span>
			<span class='product-box-top__left'>
				<span class='product-box-top__exceprt'>
					{$region}
				</span>
			</span>
		</div>
		<div class='product-box-top__image'>
			" . woocommerce_get_product_thumbnail() . "
	</div>
		<div class='product-box-top__circle'></div>
	</div>";


	echo '<div class="product-box-main card-box-main">
		<div class="product-box-main__details">
		<div class="product-box-main__title">';
	/**
	 * Hook: woocommerce_shop_loop_item_title.
	 *
	 * @hooked woocommerce_template_loop_product_title - 10
	 */
	do_action('woocommerce_shop_loop_item_title');

	echo '</div><div class="product-box-main__price">
		<span class="product-box-main__price_title">شروع قیمت از</span>';

	/**
	 * Hook: woocommerce_after_shop_loop_item_title.
	 *
	 * @hooked woocommerce_template_loop_rating - 5
	 * @hooked woocommerce_template_loop_price - 10
	 */
	// do_action('woocommerce_after_shop_loop_item_title');

	if ($product->is_type('variable')) {
		$prices = $product->get_variation_prices();
		if (!empty($prices['price'])) {
			$min_price = min($prices['price']);

			echo '<span class="price">' . wc_price($min_price) . '</span>';
		}
	} else {
		echo '<span class="price">' . $product->get_price_html() . '</span>';
	}


	echo '		</div>
			</div>
			<div class="product-box-button">
				<span class="product-box__button">مشاهده و خرید</span>
				' . $favoriteHtml . '
			</div>
		</div>

		</a>';

	/**
	 * Hook: woocommerce_after_shop_loop_item.
	 *
	 * @hooked woocommerce_template_loop_product_link_close - 5
	 * @hooked woocommerce_template_loop_add_to_cart - 10
	 */
	// do_action('woocommerce_after_shop_loop_item');
	?>
</li>