<?php

/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined('ABSPATH') || exit;
?>
<div class="d-flex e-con e-flex">
	<div class="e-con-inner">
		<div class="woocommerce-order border-shape-section accountino-order-page">

			<?php
			if ($order) :

				do_action('woocommerce_before_thankyou', $order->get_id());
			?>

				<?php if ($order->has_status('failed')) : ?>

					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
						<a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>" class="button pay"><?php esc_html_e('Pay', 'woocommerce'); ?></a>
						<?php if (is_user_logged_in()) : ?>
							<a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="button pay"><?php esc_html_e('My account', 'woocommerce'); ?></a>
						<?php endif; ?>
					</p>

				<?php else : ?>

					<?php wc_get_template('checkout/order-received.php', array('order' => $order)); ?>

					<div class="accountino-order-details accountino-cpi__price">
						<div>
							<div class="d-flex align-items-center">
								<span class="accountino-order-details__icon"><i class="far fa-hashtag"></i></span>
								<?php esc_html_e('Order number:', 'woocommerce'); ?>
							</div>
							<strong><?php echo $order->get_order_number(); ?></strong>
						</div>
						<div>
							<div class="d-flex align-items-center">
								<span class="accountino-order-details__icon"><i class="far fa-calendar-days"></i></span>
								<?php esc_html_e('Date:', 'woocommerce'); ?>
							</div>
							<strong><?php echo accountino_jalali_date($order->get_date_created()); ?></strong>
						</div>
						<?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
							<div>
								<div class="d-flex align-items-center">
									<span class="accountino-order-details__icon"><i class="far fa-envelope"></i></span>
									<?php esc_html_e('Email:', 'woocommerce'); ?>
								</div>
								<strong><?php echo $order->get_billing_email(); ?></strong>
							</div>
						<?php endif; ?>
						<div>
							<div class="d-flex align-items-center">
								<span class="accountino-order-details__icon"><i class="far fa-credit-card"></i></span>
								<?php esc_html_e('Total:', 'woocommerce'); ?>
							</div>
							<strong><?php echo $order->get_formatted_order_total(); ?></strong>
						</div>
						<div>
							<div class="d-flex">
								<span class="accountino-order-details__icon"><i class="far fa-money-bill-1"></i></span>
								<?php esc_html_e('Payment method:', 'woocommerce'); ?>
							</div>
							<strong><?php echo wp_kses_post($order->get_payment_method_title()); ?></strong>
						</div>
					</div>

				<?php endif; ?>

				<?php //do_action('woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id()); 
				?>
				<?php do_action('woocommerce_thankyou', $order->get_id()); ?>

			<?php else : ?>

				<?php wc_get_template('checkout/order-received.php', array('order' => false)); ?>

			<?php endif; ?>

		</div>
	</div>
</div>