<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 */
defined('ABSPATH') || exit;
?>

<div class="d-flex e-con e-flex">
	<div class="e-con-inner">
		<?php do_action('woocommerce_before_cart'); ?>
		<h2 class="accountino-dual-heading__title">
			<span class="accountino-dual-heading__title1"><span>سبد</span> <span>خرید</span></span>
			<span class="accountino-dual-heading__title2">Shopping Cart</span>
		</h2>
		<div class="accountino-cart-page">
			<div class="accountino-cart-page-content">
				<form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
					<?php do_action('woocommerce_before_cart_table'); ?>
					<?php do_action('woocommerce_before_cart_contents'); ?>

					<div class="accountino-cart-page-items accountino-dt-content">

						<table class="accountino-table">

							<?php
							foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
								$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
								$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
								$product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);

								if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
									$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
							?>
									<tr>
										<td class="accountino-cpi__remove" width="10">
											<?php
											echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
												'woocommerce_cart_item_remove_link',
												sprintf(
													'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
													esc_url(wc_get_cart_remove_url($cart_item_key)),
													/* translators: %s is the product name */
													esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
													esc_attr($product_id),
													esc_attr($_product->get_sku())
												),
												$cart_item_key
											);
											?>
										</td>
										<td class="accountino-cpi__thumbnail">
											<?php
											$thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

											if (! $product_permalink) {
												echo $thumbnail; // PHPCS: XSS ok.
											} else {
												printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
											}
											?>
										</td>
										<td class="accountino-cpi__product">
											<?php
											if (! $product_permalink) {
												echo wp_kses_post($product_name . '&nbsp;');
											} else {
												echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $_product->get_name()), $cart_item, $cart_item_key));
											}

											do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

											// Meta data.
											echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

											// Backorder notification.
											if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
												echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
											}
											?>
										</td>
										<td class="accountino-cpi__price accountino-cpi__dual_line">
											<p>جمع جزء:</p>
											<span>
												<?php
												echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
												?>
											</span>
										</td>
										<td class="accountino-cpi__quantity accountino-cpi__dual_line">
											<p>تعداد:</p>
											<span>
												<?php
												if ($_product->is_sold_individually()) {
													$min_quantity = 1;
													$max_quantity = 1;
												} else {
													$min_quantity = 0;
													$max_quantity = $_product->get_max_purchase_quantity();
												}

												?>
												<span class="quantity-wrapper">
													<button type="button" class="qty-plus">+</button>
													<input type="number" id="quantity" name="cart[<?= $cart_item_key; ?>][qty]" readonly class="input-text qty text" step="1" inputmode="numeric" value="<?= $cart_item['quantity']; ?>" min="<?= $min_quantity ?>" max="<?= $max_quantity ?>" title="<?= $product_name; ?>" size="4">
													<button type="button" class="qty-minus">-</button>
												</span>
											</span>
										</td>
										<td class="accountino-cpi__price accountino-cpi__dual_line">
											<p>جمع کل:</p>
											<span>
												<?php
												echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // PHPCS: XSS ok.
												?>
											</span>
										</td>
									</tr>
							<?php
								}
							}
							do_action('woocommerce_cart_contents');
							?>
							<tr>
								<td colspan="5">
									<?php if (wc_coupons_enabled()) { ?>
										<div class="coupon accountino-cart-page-coupon accountino-form">
											<label for="coupon_code"><?php esc_html_e('Coupon:', 'woocommerce'); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" /> <button type="submit" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?></button>
											<?php do_action('woocommerce_cart_coupon'); ?>
										</div>
									<?php } ?>
								</td>
								<td>
									<button type="submit" class="accountino-btn" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?></button>
								</td>
							</tr>
							<?php do_action('woocommerce_cart_actions'); ?>

							<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
							<?php do_action('woocommerce_after_cart_contents'); ?>
						</table>
					</div>


					<?php do_action('woocommerce_after_cart_table'); ?>
				</form>
			</div>
			<div class="accountino-cart-page-sidebar">

				<?php do_action('woocommerce_before_cart_collaterals'); ?>

				<div class="cart-collaterals">
					<?php
					/**
					 * Cart collaterals hook.
					 *
					 * @hooked woocommerce_cross_sell_display
					 * @hooked woocommerce_cart_totals - 10
					 */
					do_action('woocommerce_cart_collaterals');
					?>
				</div>
			</div>
		</div>
		<?php do_action('woocommerce_after_cart'); ?>
	</div>
</div>