<?php

/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package Accountino
 */
if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}


while (have_posts()) :
	the_post();

	Accountino_Post_Service::setPostViews(get_the_ID());
	$postTitle = trim(get_the_title());

	$postTitleSeparated = null;
	if (strpos($postTitle, ' ') !== false) {
		$postTitleExploded = array_filter(explode(' ', $postTitle));
		$postTitleSeparated = "<span>" . implode('</span> <span>', $postTitleExploded) . "</span>";
	} else {
		$postTitleSeparated = "<span>{$postTitle}</span>";
	}
?>

	<div class="d-flex e-con e-flex">
		<div class="e-con-inner">
			<div class="accountino-single-container">
				<main id="content" <?php post_class('site-main'); ?>>

					<div class="page-content">
						<h1 class="accountino-dual-heading__title accountino-dual-heading__small">
							<span class="accountino-dual-heading__title1"><?= $postTitleSeparated; ?></span>
							<?php if (!empty($englishName)) { ?>
								<span class="accountino-dual-heading__title2"><?= $englishName; ?></span>
							<?php } ?>
						</h1>

						<?php include ACCOUNTINO_PATH . '/template-parts/shared/post-meta.php'; ?>

						<?php the_content(); ?>

						<?php wp_link_pages(); ?>

						<?php if (has_tag()) : ?>
							<div class="post-tags">
								<?php the_tags('<span class="tag-links">' . esc_html__('Tagged ', 'accountino'), ', ', '</span>'); ?>
							</div>
						<?php endif; ?>

						<?php include(ACCOUNTINO_PATH . '/template-parts/shared/favorite.php'); ?>
					</div>

					<?php //comments_template(); 
					?>

				</main>
				<aside class="accountino-single-sidebar">
					<h2 class="accountino-dual-heading__title accountino-dual-heading__small">
						<span class="accountino-dual-heading__title1"><span>مقاله</span> <span>های</span> <span>مرتبط</span></span>
					</h2>
					<div class="accountino-single-sidebar__related accountino-blog accountino-blog-grid">
						<?php
						$postCategory = get_the_category();
						$args = [
							'post_type' => 'post',
							'posts_per_page' => 3,
							'post__not_in' => [get_the_ID()]
						];

						if (!empty($postCategory[0]->term_id)) {
							$args['tax_query'] = [[
								'taxonomy' => 'category',
								'field'    => 'id',
								'terms'    => $postCategory[0]->term_id,
							]];
						}

						$loop = new WP_Query($args);
						if ($loop->have_posts()) {
							while ($loop->have_posts()) {
								$loop->the_post();
								global $post;

								echo Accountino_Post_Category_Service::generatePost($post);
							}
						}

						?>
					</div>
				</aside>
			</div>
		</div>

	<?php
endwhile;
