<?php

/**
 * The template for displaying header.
 *
 * @package Accountino
 */
if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$get_id = accountino_custom_header_template();

// Check if page is Elementor page.
$elementor = get_post_meta($get_id, '_elementor_edit_mode', true);

// Get content.
$get_content = accountino_header_template_content();

// Get classes.
$classes = array();

// Add container class.
if (false === get_theme_mod('accountino_header_full_width', true)) {
	$classes[] = 'e-con-inner';
}

// Turn classes into space seperated string.
$classes = implode(' ', $classes); ?>

<header id="site-header" class="site-header e-con e-flex">
	<div id="site-header-inner" class="<?php echo esc_attr($classes); ?>">
		<?php

		if (defined('ELEMENTOR_VERSION')) {
			echo \Elementor\Plugin::instance()->frontend->get_builder_content($get_id, true);
		} else {
			// Display template content.
			echo do_shortcode($get_content);
		}

		?>
	</div>
</header>