<?php

/**
 * The template for displaying header.
 *
 * @package Accountino
 */
if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$get_id = accountino_custom_footer_template();

// Check if page is Elementor page.
$elementor = get_post_meta($get_id, '_elementor_edit_mode', true);

// Get content.
$get_content = accountino_footer_template_content();

// Get classes.
$classes = array();

// Add container class.
if (true != get_theme_mod('accountino_footer_full_width', true)) {
	$classes[] = 'e-con-inner';
}

// Turn classes into space seperated string.
$classes = implode(' ', $classes); ?>

<footer id="site-footer" class="site-footer e-con e-flex">
	<div id="site-footer-inner" class="<?php echo esc_attr($classes); ?>">

		<?php

		if (defined('ELEMENTOR_VERSION')) {
			// If Elementor.
			echo \Elementor\Plugin::instance()->frontend->get_builder_content($get_id, true);
		} else {
			// Display template content.
			echo do_shortcode($get_content);
		}

		?>
	</div>
</footer>