<?php

/**
 * The template for displaying archive pages.
 *
 * @package Accountino
 */

use Elementor\Utils;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

?>

<div class="d-flex e-con e-flex">
	<div class="e-con-inner">
		<div class="accountino-archive-container">
			<aside class="accountino-archive-sidebar">
				<ul class="accountino-archive-sidebar__categories">
					<?php
					$currentPageData = get_queried_object();
					$categories = get_categories(['hide_empty' => false]);
					foreach ($categories as $category) {
						$isActive = isset($currentPageData->term_id) && $currentPageData->term_id == $category->cat_ID;
						$categoryLink = get_category_link($category->cat_ID);
						$activeClass = $isActive ? 'active' : '';
						$thumbnail = get_term_meta($category->cat_ID, '_thumbnail_id', true);
						$icon = !empty($thumbnail) ? wp_get_attachment_image($thumbnail, 'thumbnail') : null;
						$englishName = get_term_meta($category->cat_ID, '_english_name', true);
						echo "<li>
							<a href='{$categoryLink}' class='{$activeClass}'>
								{$icon}
								<div>
									{$category->name}
									<span class='category-english-name'>{$englishName}</span>
								</div> 
								" . ($isActive ? '<i class="fas fa-chevron-left"></i>' : '') . "
							</a>
						</li>";
					}
					?>
				</ul>
			</aside>
			<main id="content" class="site-main accountino-archive-main">
				<div class="page-content">
					<div class="accountino-blog accountino-blog-grid">
						<?php
						while (have_posts()) {
							the_post();
							echo Accountino_Post_Category_Service::generatePost($post);
						} ?>
					</div>
				</div>

				<?php
				global $wp_query;
				if ($wp_query->max_num_pages > 1) :
					$prev_arrow = is_rtl() ? '&rarr;' : '&larr;';
					$next_arrow = is_rtl() ? '&larr;' : '&rarr;';
				?>
					<nav class="pagination">
						<div class="nav-previous"><?php
													/* translators: %s: HTML entity for arrow character. */
													previous_posts_link(sprintf(esc_html__('%s Previous', 'accountino'), sprintf('<span class="meta-nav">%s</span>', $prev_arrow)));
													?></div>
						<div class="nav-next"><?php
												/* translators: %s: HTML entity for arrow character. */
												next_posts_link(sprintf(esc_html__('Next %s', 'accountino'), sprintf('<span class="meta-nav">%s</span>', $next_arrow)));
												?></div>
					</nav>
				<?php endif; ?>

			</main>
		</div>
	</div>
</div>