<?php

/**
 * The template for displaying header.
 *
 * @package Accountino
 */
if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$get_id = accountino_custom_not_found_template();

// Check if page is Elementor page.
$elementor = get_post_meta($get_id, '_elementor_edit_mode', true);

// Get content.
$get_content = accountino_not_found_template_content();

?>

<main id="content" class="site-main">
	<?php
	if (!empty($get_id)) {
		if (defined('ELEMENTOR_VERSION')) {
			// If Elementor.
			echo \Elementor\Plugin::instance()->frontend->get_builder_content($get_id, true);
		} else {
			// Display template content.
			echo do_shortcode($get_content);
		}
	} else {
		if (apply_filters('accountino_page_title', true)) : ?>
			<div class="page-header">
				<h1 class="entry-title"><?php echo esc_html__('صفحه پیدا نشد.', 'accountino'); ?></h1>
			</div>
		<?php endif; ?>

		<div class="page-content">
			<p><?php echo esc_html__('انگار هیچ چیزی در این مکان پیدا نشد.', 'accountino'); ?></p>
		</div>
	<?php } ?>
</main>