<?php if (is_front_page()) return; ?>
<div class="d-flex e-con e-flex">
    <div class="e-con-inner">
        <?php
        echo '<nav class="accountino-breadcrumb"><ul>';
        echo '<li><a href="' . home_url() . '">' . get_option('blogname') . '</a></li>';

        $separator = '<li class="separator"><i class="fas fa-chevron-left"></i></li>';

        if ((is_category() || is_single()) && !is_product()) {
            $categories = get_the_category();
            if (!empty($categories)) {
                $cat = $categories[0];
                echo $separator . '<li><a href="' . get_category_link($cat->term_id) . '">' . esc_html($cat->name) . '</a></li>';
            }

            if (is_single()) {
                echo $separator . '<li>' . get_the_title() . '</li>';
            }
        } elseif (is_page()) {
            global $post;
            if ($post->post_parent) {
                $parents = array_reverse(get_post_ancestors($post->ID));
                foreach ($parents as $parent) {
                    echo $separator . '<li><a href="' . get_permalink($parent) . '">' . get_the_title($parent) . '</a></li>';
                }
            }
            echo $separator . '<li>' . get_the_title() . '</li>';
        } elseif (is_home() && !is_front_page()) {
            echo $separator . '<li>' . get_the_title(get_option('page_for_posts')) . '</li>';
        } elseif (is_search()) {
            echo $separator . '<li>نتایج جستجو برای "' . get_search_query() . '"</li>';
        } elseif (is_tag()) {
            echo $separator . '<li>برچسب: ' . single_tag_title('', false) . '</li>';
        } elseif (is_author()) {
            echo $separator . '<li>نویسنده: ' . get_the_author() . '</li>';
        } elseif (is_archive()) {
            if (is_post_type_archive()) {
                echo $separator . '<li>' . post_type_archive_title('', false) . '</li>';
            } elseif (is_tax()) {
                $term = get_queried_object();
                echo $separator . '<li>' . $term->name . '</li>';
            } else {
                echo $separator . '<li>' . get_the_archive_title() . '</li>';
            }
        } elseif (function_exists('is_woocommerce') && is_woocommerce()) {
            if (is_shop()) {
                echo $separator . '<li>' . get_the_title(wc_get_page_id('shop')) . '</li>';
            } elseif (is_product_category()) {
                $term = get_queried_object();
                $ancestors = get_ancestors($term->term_id, 'product_cat');
                $ancestors = array_reverse($ancestors);
                foreach ($ancestors as $ancestor_id) {
                    $ancestor = get_term($ancestor_id, 'product_cat');
                    echo $separator . '<li><a href="' . get_term_link($ancestor) . '">' . $ancestor->name . '</a></li>';
                }
                echo $separator . '<li>' . $term->name . '</li>';
            } elseif (is_product()) {
                echo $separator . '<li><a href="' . get_permalink(wc_get_page_id('shop')) . '">' . get_the_title(wc_get_page_id('shop')) . '</a></li>';
                $terms = get_the_terms(get_the_ID(), 'product_cat');
                if (!empty($terms)) {
                    $term = array_shift($terms);
                    echo $separator . '<li><a href="' . get_term_link($term) . '">' . $term->name . '</a></li>';
                }
                echo $separator . '<li>' . get_the_title() . '</li>';
            }
        } elseif (is_404()) {
            echo $separator . '<li>404 - صفحه پیدا نشد</li>';
        }

        echo '</ul></nav>';
        ?>
    </div>
</div>