<?php

/**
 * The site's entry point.
 *
 * Loads the relevant template part,
 * the loop is executed (when needed) by the relevant template part.
 *
 * @package Accountino
 */
if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

get_header();

$is_elementor_theme_exist = function_exists('elementor_theme_do_location');
if (is_singular('post')) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('single')) {
		get_template_part('template-parts/single');
	}
} elseif (is_front_page()) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('front_page')) {
		get_template_part('template-parts/front_page');
	}
} elseif (is_archive() || is_home()) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('archive')) {
		get_template_part('template-parts/archive');
	}
} elseif (is_search()) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('archive')) {
		get_template_part('template-parts/search');
	}
} elseif (is_singular('page')) {
	if (! $is_elementor_theme_exist || ! elementor_theme_do_location('pages')) {
		get_template_part('template-parts/pages');
	}
} elseif (! $is_elementor_theme_exist || ! elementor_theme_do_location('404')) {
	get_template_part('template-parts/404');
}

get_footer();
