<?php

require(ACCOUNTINO_PATH . '/includes/woocommerce/product-service.php');
require(ACCOUNTINO_PATH . '/includes/woocommerce/product-attributes-service.php');
require(ACCOUNTINO_PATH . '/includes/woocommerce/account-service.php');

/**
 * Woocommerce class
 */

if (! class_exists('Accountino_Woocommerce')) :

    class Accountino_Woocommerce
    {

        /**
         * Setup class.
         *
         * @since 1.4.0
         */
        public function __construct()
        {
            new Accountino_Woocommerce_Product();
            new Accountino_Woocommerce_Product_Attributes();
            new Accountino_Woocommerce_Account();

            // Active Products On Elementor Settings
            add_action('elementor/init', [$this, 'activeProductsOnElementorSetting']);

            add_action('product_cat_add_form_fields', [$this, 'categoriesCustomFieldsAdd']);
            add_action('product_cat_edit_form_fields', [$this, 'categoriesCustomFieldsEdit']);
            add_action('edited_product_cat', [$this, 'saveCategoriesCustomFields']);
            add_action('create_product_cat', [$this, 'saveCategoriesCustomFields']);

            add_filter('woocommerce_catalog_orderby', [$this, 'changeSortFieldLabels']);

            add_filter('loop_shop_columns', [$this, 'setWoocommerceColumns']);

            // Handle Product Views
            add_action('template_redirect', [$this, 'trackProductViews']);

            // Handle the Query when most reviewed
            add_action('woocommerce_product_query', [$this, 'filterByMostViews']);

            add_action('init', [$this, 'removeBreadcrumbs']);

            $vars = array('ajax_url' => admin_url('admin-ajax.php'));
            wp_localize_script('wc-variation-add-to-cart', 'WC_VARIATION_ADD_TO_CART', $vars);

            add_action('wp_ajax_accountino_woocommerce_ajax_add_to_cart', [$this, 'accountino_woocommerce_ajax_add_to_cart']);
            add_action('wp_ajax_nopriv_accountino_woocommerce_ajax_add_to_cart', [$this, 'accountino_woocommerce_ajax_add_to_cart']);
        }

        const CUSTOM_PRODUCT_TYPES = [
            'اکانت' => [
                'name' => 'اکانت',
                'plural' => 'اکانت های'
            ],
            'محصول' => [
                'name' => 'محصول',
                'plural' => 'محصولات'
            ]
        ];

        public function activeProductsOnElementorSetting()
        {
            $supported = get_option('elementor_cpt_support', []) ?? [];

            if (!in_array('product', $supported)) {
                $supported[] = 'product';
                update_option('elementor_cpt_support', $supported);
            }
        }

        public static function categoriesCustomFieldsAdd()
        { ?>
            <div class="form-field">
                <label for="accountino_product_category_type"><?php esc_html_e('نوع دسته بندی', THEME_TEXT_DOMAIN); ?></label>
                <select name="accountino_product_category_type" id="accountino_product_category_type">
                    <option value="اکانت">اکانت</option>
                    <option value="محصول">محصول</option>
                </select>
                <p class="description"><?php esc_html_e('نوع دسته بندی را مشخص کنید.', THEME_TEXT_DOMAIN); ?></p>
            </div>
        <?php
        }

        public static function categoriesCustomFieldsEdit($term)
        {
            $value = get_term_meta($term->term_id, 'accountino_product_category_type', true); ?>
            <tr class="form-field">
                <th scope="row"><label for="accountino_product_category_type"><?php esc_html_e('نوع دسته بندی', THEME_TEXT_DOMAIN); ?></label></th>
                <td>
                    <select name="accountino_product_category_type" id="accountino_product_category_type">
                        <option value="اکانت" <?php echo esc_attr($value) == 'اکانت' ? 'selected' : null; ?>>اکانت</option>
                        <option value="محصول" <?php echo esc_attr($value) == 'محصول' ? 'selected' : null; ?>>محصول</option>
                    </select>
                    <p class="description"><?php esc_html_e('نوع دسته بندی را مشخص کنید.', THEME_TEXT_DOMAIN); ?></p>
                </td>
            </tr>

<?php
        }

        public static function saveCategoriesCustomFields($term_id)
        {
            if (isset($_POST['accountino_product_category_type'])) {
                update_term_meta($term_id, 'accountino_product_category_type', sanitize_text_field($_POST['accountino_product_category_type']));
            }
        }

        public function accountino_woocommerce_ajax_add_to_cart()
        {

            \WC_AJAX::get_refreshed_fragments();
            wp_die();
        }

        public static function removeBreadcrumbs()
        {
            remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
            remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 10);
            remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
            remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
            remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
            remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        }

        public static function changeSortFieldLabels($options)
        {
            $options['menu_order'] = 'پیشفرض';
            $options['popularity'] = 'منتخب';
            $options['rating'] = 'پیشنهادات کاربران';
            $options['date'] = 'جدیدترین ها';
            $options['price'] = 'ارزان ترین';
            $options['price-desc'] = 'گران ترین';
            $options['most-viewed'] = 'پربازدیدترین ها';

            return $options;
        }

        public static function trackProductViews()
        {
            if (is_singular('product')) {
                global $post;
                $views = (int) get_post_meta($post->ID, 'accountino_product_views', true);
                $views++;
                update_post_meta($post->ID, 'accountino_product_views', $views);
            }
        }

        public static function filterByMostViews($query)
        {
            if (!is_admin() && is_woocommerce() && isset($_GET['orderby']) && $_GET['orderby'] === 'most-viewed') {
                $query->set('meta_key', 'accountino_product_views');
                $query->set('orderby', 'meta_value_num');
                $query->set('order', 'DESC');
            }
        }

        public static function setWoocommerceColumns()
        {
            return 3; // Set to 3 columns
        }
    }


endif;

return new Accountino_Woocommerce();
