<?php

require_once(ACCOUNTINO_PATH . '/includes/woocommerce/helper/WoocommerceHelper.php');

use Accountino\Woocommerce\Accountino_Woocommerce_Helper;

if (! class_exists('Accountino_Woocommerce_Product')) :

    class Accountino_Woocommerce_Product
    {

        public function __construct()
        {
            // Add Meta Box
            add_action('add_meta_boxes', [$this, 'addMetaBoxForNewFields']);
            add_action('save_post_product', [$this, 'saveNewMetaFields']);

            // Handle the Query when filters
            add_action('woocommerce_product_query', [$this, 'productQueryFilters']);
        }

        public function addMetaBoxForNewFields()
        {
            add_meta_box(
                'custom_product_meta',
                __('اطلاعات پیشترفته محصول', 'accountino'),
                [$this, 'addProductNewFields'],
                'product',
                'side',
                'default'
            );
        }

        public function addProductNewFields($post)
        {
            // Nonce field for security
            wp_nonce_field('custom_product_meta_nonce', 'custom_product_meta_nonce_field');

?>
            <p>
                <label for="english_name"><strong><?php esc_html_e('نام انگلیسی محصول:', 'accountino'); ?></strong></label>
                <input type="text" name="english_name" id="english_name" value="<?= get_post_meta($post->ID, '_english_name', true); ?>" style="width: 100%;">
            </p>
            <p>
                <label for="product_region"><strong><?php esc_html_e('ریجن:', 'accountino'); ?></strong></label>
                <input type="text" name="product_region" id="product_region" value="<?= get_post_meta($post->ID, '_product_region', true); ?>" style="width: 100%;">
            </p>
            <p>
                <label for="buy_again_percent"><strong><?php esc_html_e('درصد خرید دوباره:', 'accountino'); ?></strong></label>
                <input type="text" name="buy_again_percent" id="buy_again_percent" value="<?= get_post_meta($post->ID, '_buy_again_percent', true); ?>" style="width: 100%;">
            </p>
            <p>
                <label for="satisfied_customers"><strong><?php esc_html_e('درصد مشتری رضایتمند:', 'accountino'); ?></strong></label>
                <input type="text" name="satisfied_customers" id="satisfied_customers" value="<?= get_post_meta($post->ID, '_satisfied_customers', true); ?>" style="width: 100%;">
            </p>
            <p>
                <label for="last_month_activate"><strong><?php esc_html_e('فعالسازی در ماه گذشته:', 'accountino'); ?></strong></label>
                <input type="text" name="last_month_activate" id="last_month_activate" value="<?= get_post_meta($post->ID, '_last_month_activate', true); ?>" style="width: 100%;">
            </p>
<?php

        }

        public static function saveNewMetaFields($post_id)
        {

            if (!isset($_POST['custom_product_meta_nonce_field']) || !wp_verify_nonce($_POST['custom_product_meta_nonce_field'], 'custom_product_meta_nonce')) {
                return;
            }

            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;


            if (isset($_POST['english_name'])) {
                update_post_meta($post_id, '_english_name', sanitize_text_field($_POST['english_name']));
            } else {
                update_post_meta($post_id, '_english_name', '');
            }

            if (isset($_POST['product_region'])) {
                update_post_meta($post_id, '_product_region', sanitize_text_field($_POST['product_region']));
            } else {
                update_post_meta($post_id, '_product_region', '');
            }



            if (isset($_POST['buy_again_percent'])) {
                update_post_meta($post_id, '_buy_again_percent', sanitize_text_field($_POST['buy_again_percent']));
            } else {
                update_post_meta($post_id, '_buy_again_percent', 100);
            }

            if (isset($_POST['satisfied_customers'])) {
                update_post_meta($post_id, '_satisfied_customers', sanitize_text_field($_POST['satisfied_customers']));
            } else {
                update_post_meta($post_id, '_satisfied_customers', 100);
            }

            if (isset($_POST['last_month_activate'])) {
                update_post_meta($post_id, '_last_month_activate', sanitize_text_field($_POST['last_month_activate']));
            } else {
                update_post_meta($post_id, '_last_month_activate', 10000);
            }
        }


        public static function productQueryFilters($query)
        {

            if (is_admin() || !is_woocommerce() || empty($_GET)) return;


            if (isset($_GET['duration-time']) && !empty($_GET['duration-time'])) {
                $query->set('tax_query', [
                    [
                        'taxonomy' => 'pa_duration-time',
                        'field'    => 'term_id',
                        'terms'    => $_GET['duration-time'],
                        'operator' => 'IN',
                    ],
                ]);
            }

            if (isset($_GET['activation_method']) && !empty($_GET['activation_method'])) {
                $query->set('tax_query', [
                    [
                        'taxonomy' => 'pa_activation_mode',
                        'field'    => 'term_id',
                        'terms'    => $_GET['activation_method'],
                        'operator' => 'IN',
                    ],
                ]);
            }

            if (isset($_GET['language']) && !empty($_GET['language'])) {
                $query->set('tax_query', [
                    [
                        'taxonomy' => 'pa_language',
                        'field'    => 'term_id',
                        'terms'    => $_GET['language'],
                        'operator' => 'IN',
                    ],
                ]);
            }

            if (isset($_GET['categories']) && !empty($_GET['categories'])) {

                $query->set('tax_query', [
                    [
                        'taxonomy' => 'product_cat',
                        'field'    => 'slug',
                        'terms'    => $_GET['categories'],
                        'operator' => 'IN',
                    ],
                ]);
            }
        }


        // Get User Comments
        public static function getUserComments()
        {
            return get_comments([
                'user_id'   => get_current_user_id(),
                'status'    => 'all',
                'number'    => 0,
                'post__in'  => get_posts([
                    'post_type'   => 'product',
                    'numberposts' => -1,
                    'fields'      => 'ids',
                ]),
            ]);
        }
    }


endif;
