<?php
if (! class_exists('Accountino_Woocommerce_Product_Attributes')) :

    class Accountino_Woocommerce_Product_Attributes
    {

        public function __construct()
        {
            // Add Thumbnail Field
            add_action('woocommerce_after_add_attribute_fields', [$this, 'addThumbnailForAttributes']);
            add_action('woocommerce_after_edit_attribute_fields', [$this, 'addThumbnailForAttributes']);
            add_action('woocommerce_attribute_added', [$this, 'saveThumbnailForAttributes'], 10, 2);
            add_action('woocommerce_attribute_updated', [$this, 'saveThumbnailForAttributes'], 10, 3);


            add_action('admin_enqueue_scripts', [$this, 'loadMediaScript']);
            add_action('admin_footer', [$this, 'uploadFieldScript']);
        }

        public function addThumbnailForAttributes()
        {
            $attributeId = isset($_GET['edit']) ? absint($_GET['edit']) : 0;
            $attribute = wc_get_attribute($attributeId);

            $attributeSlug = $attribute->slug;
            $thumbnail = get_option("_attribute_thumbnail_{$attributeSlug}"); ?>
            <div class="form-field">
                <label for="attribute_thumbnail"><?php _e('بند انگشتی', 'woocommerce'); ?></label>
                <input type="hidden" name="attribute_thumbnail" id="attribute_thumbnail" value="<?php echo esc_attr($thumbnail ?? ''); ?>" />
                <div id="attribute_thumbnail_preview" style="margin-bottom: 10px;">
                    <?php if (!empty($thumbnail)) echo wp_get_attachment_image($thumbnail, 'thumbnail'); ?>
                </div>
                <button type="button" class="button upload_attribute_thumbnail"><?php _e('انتخاب عکس', 'woocommerce'); ?></button>
                <button type="button" class="button remove_attribute_thumbnail"><?php _e('حذف عکس', 'woocommerce'); ?></button>
            </div>
            <?php
        }

        public function saveThumbnailForAttributes($attribute_id, $attribute_data)
        {
            if (isset($_POST['attribute_thumbnail'])) {
                $attributeSlug = $attribute_data['attribute_name'];
                update_option("_attribute_thumbnail_pa_{$attributeSlug}", sanitize_text_field($_POST['attribute_thumbnail']));
            }
        }

        public static function loadMediaScript($hook)
        {
            $screen = get_current_screen();
            if ($screen && $screen->id === 'product_page_product_attributes') {
                wp_enqueue_media();
            }
        }

        public static function uploadFieldScript()
        {
            $screen = get_current_screen();
            if ($screen && $screen->id === 'product_page_product_attributes') { ?>
                <script>
                    jQuery(document).ready(function($) {
                        var mediaUploader;

                        $('.upload_attribute_thumbnail').on('click', function(e) {
                            e.preventDefault();

                            if (mediaUploader) {
                                mediaUploader.open();
                                return;
                            }

                            mediaUploader = wp.media({
                                title: 'انتخاب عکس',
                                button: {
                                    text: 'استفاده از عکس'
                                },
                                multiple: false
                            });

                            mediaUploader.on('select', function() {
                                var attachment = mediaUploader.state().get('selection').first().toJSON();
                                $('#attribute_thumbnail').val(attachment.id);
                                $('#attribute_thumbnail_preview').html('<img src="' + attachment?.image?.src + '" style="max-width: 100px;" />');
                            });

                            mediaUploader.open();
                        });

                        $('.remove_attribute_thumbnail').on('click', function() {
                            $('#attribute_thumbnail').val('');
                            $('#attribute_thumbnail_preview').empty();
                        });
                    });
                </script>
<?php
            }
        }
    }


endif;
