<?php
if (! class_exists('Accountino_Woocommerce_Account_Ticketing')) :

    class Accountino_Woocommerce_Account_Ticketing
    {

        public function __construct()
        {
            // Create Post Type
            add_action('init', [$this, 'createPostType']);

            // Handle Submission
            add_action('init', [$this, 'submitTicket']);


            // Edit Table
            add_action('current_screen', [$this, 'changeEditText']);
            add_filter('post_row_actions', [$this, 'removeQuickEdit'], 10, 2);

            add_filter('manage_support_ticket_posts_columns', [$this, 'ticketTableHeading']);
            add_action('manage_support_ticket_posts_custom_column', [$this, 'ticketTableBody'], 10, 2);

            // Edit Page Information
            add_action('add_meta_boxes', [$this, 'addEditPageMetaBox']);
        }


        public static function createPostType()
        {
            register_post_type('support_ticket', [
                'label' => 'تماس با پشتیبانی',
                'public' => false,
                'show_ui' => true,
                'capability_type' => 'post',
                'capabilities'    => ['create_posts' => 'do_not_allow'],
                'map_meta_cap'    => true,
                'supports' => ['title', 'editor', 'author', 'comments'],
                'has_archive' => false,
                'hierarchical' => false,
            ]);
        }

        public const DEPARTMENTS = [
            'technical' => 'پشتیبانی فنی',
            'billing' => 'پشتیبانی مالی',
            'support' => 'پشتیبانی فروش',
        ];

        public const  PRIORITY = [
            'low' => 'کم',
            'normal' => 'متوسط',
            'high' => 'زیاد',
        ];

        public const  STATUS = [
            'open' => 'منتظر پاسخ',
            'pending' => 'درحال بررسی',
            'closed' => 'بسته شده',
        ];

        public static function submitTicket()
        {
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['tickle_submit'])) {
                $title        = sanitize_text_field($_POST['ticket_title']);
                $department   = sanitize_text_field($_POST['ticket_department'] ?? '');
                $priority     = sanitize_text_field($_POST['ticket_priority'] ?? 'normal');
                $order_no     = sanitize_text_field($_POST['ticket_order_no']);
                $product_name = sanitize_text_field($_POST['ticket_product_name']);
                $description  = wp_kses_post($_POST['ticket_content']);

                // Handle file upload
                $attachment_url = '';
                if (!empty($_FILES['ticket_attachment']['name'])) {
                    require_once(ABSPATH . 'wp-admin/includes/file.php');
                    $uploaded = wp_handle_upload($_FILES['ticket_attachment'], ['test_form' => false]);

                    if (!isset($uploaded['error'])) {
                        $attachment_url = $uploaded['url'];
                    }
                }

                $post_id = wp_insert_post([
                    'post_type'   => 'support_ticket',
                    'post_title'  => $title,
                    'post_content' => $description,
                    'post_status' => 'publish',
                    'post_author' => get_current_user_id(),
                ]);

                update_post_meta($post_id, '_ticket_department', $department);
                update_post_meta($post_id, '_ticket_priority', $priority);
                update_post_meta($post_id, '_ticket_order_no', $order_no);
                update_post_meta($post_id, '_ticket_product_name', $product_name);
                if ($attachment_url) {
                    update_post_meta($post_id, '_ticket_attachment_url', $attachment_url);
                }

                wp_redirect(wc_get_account_endpoint_url('contact_support'));
                exit;
            }
        }

        public static function getTicketStatus($ticketId, $getText = true)
        {
            $ticketData = get_post($ticketId);
            $ticketAuthor = $ticketData->post_author;
            $ticketDate = get_the_date('Y-m-d', $ticketId);

            $ticketAnswers = get_comments(['post_id' => $ticketId, 'order' => 'ASC']);
            $lastTicketAuthor = $lastTicketDate = null;
            if (!empty($ticketAnswers)) {
                $lastTicket = end($ticketAnswers);
                $lastTicketAuthor = $lastTicket->user_id;
                $lastTicketDate = get_comment_date('Y-m-d', $lastTicket);
            }

            $statusText = $getText ? self::STATUS['open'] : 'open';

            if (!empty($lastTicketAuthor)) {
                if ($ticketAuthor !== $lastTicketAuthor) {
                    $statusText = $getText ? self::STATUS['pending'] : 'pending';
                }
                if (!empty($lastTicketDate)) {
                    $dateDifference = round((strtotime($lastTicketDate) - strtotime($ticketDate)) / (60 * 60 * 24));
                    if ($dateDifference > 3)
                        $statusText = $getText ? self::STATUS['closed'] : 'closed';
                }
            }

            return $statusText;
        }


        public static function changeEditText($screen)
        {
            if (!is_object($screen) || $screen->post_type !== 'support_ticket') {
                return;
            }

            add_filter('gettext', function ($translated_text, $text, $domain) {

                switch ($translated_text) {
                    case 'ویرایش':
                        return 'پاسخ به تیکت';
                    case 'دیدگاه‌ها':
                        return 'پاسخ ها';
                    case 'فرستادن دیدگاه':
                        return 'پاسخ دادن';
                }


                return $translated_text;
            }, 10, 3);
        }

        public static function removeQuickEdit($actions, $post)
        {
            if ($post->post_type === 'support_ticket') {
                unset($actions['inline hide-if-no-js']); // This is "Quick Edit"
            }
            return $actions;
        }

        public static function ticketTableHeading($columns)
        {
            $columns['ticket_department'] = 'دپارتمان';
            $columns['ticket_priority'] = 'اولویت';
            $columns['ticket_order_no'] = 'شناسه سفارش';
            $columns['ticket_product_name'] = 'نام محصول';
            $columns['author'] = 'نام مشتری';
            return $columns;
        }

        public static function ticketTableBody($column, $post_id)
        {
            switch ($column) {
                case 'ticket_product_name':
                    echo get_post_meta($post_id, '_ticket_product_name', true) ?? null;
                    break;
                case 'ticket_order_no':
                    echo get_post_meta($post_id, '_ticket_order_no', true) ?? null;
                    break;
                case 'ticket_department':
                    $department = get_post_meta($post_id, '_ticket_department', true);
                    echo !empty($department) ? Accountino_Woocommerce_Account_Ticketing::DEPARTMENTS[$department] : null;
                    break;
                case 'ticket_priority':
                    $priority = get_post_meta($post_id, '_ticket_priority', true);
                    echo !empty($priority) ? Accountino_Woocommerce_Account_Ticketing::PRIORITY[$priority] : null;
                    break;
            }
        }

        public function addEditPageMetaBox()
        {
            add_meta_box(
                'support_ticket_info',
                'اطلاعات تیکت',
                [$this, 'renderTicketInfoBox'],
                'support_ticket',
                'side',
                'default'
            );
        }

        public function renderTicketInfoBox($post)
        {
            $department = get_post_meta($post->ID, '_ticket_department', true);
            $departmentText = !empty($department) ? Accountino_Woocommerce_Account_Ticketing::DEPARTMENTS[$department] : null;

            $priority = get_post_meta($post->ID, '_ticket_priority', true);
            $priorityText = !empty($priority) ? Accountino_Woocommerce_Account_Ticketing::PRIORITY[$priority] : null;
            echo '<p><strong> اولویت:</strong> ' . $priorityText . '</span>';
            echo '<p><strong> دپارتمان:</strong> ' . $departmentText . '</span>';
            echo '<p><strong> شناسه سفارش:</strong> ' . get_post_meta($post->ID, '_ticket_order_no', true) . '</span>';
            echo '<p><strong>نام محصول:</strong> ' . get_post_meta($post->ID, '_ticket_product_name', true) . '</span>';
        }
    }


endif;
