<?php
require(ACCOUNTINO_PATH . '/includes/woocommerce/account-ticketing-service.php');
require(ACCOUNTINO_PATH . '/includes/woocommerce/account-notifications-service.php');

if (! class_exists('Accountino_Woocommerce_Account')) :

    class Accountino_Woocommerce_Account
    {

        private const NEW_TABS = [
            'favorites' => 'علاقه مندی ها',
            'comments' => 'دیدگاه ها',
            'contact_support' => 'تماس با پشتیبانی',
            'notifications' => 'اخبار و اطلاعیه ها',
            'licenses' => 'اشتراک ها و لایسنس ها',
        ];


        public function __construct()
        {
            new Accountino_Woocommerce_Account_Ticketing();
            new Accountino_Woocommerce_Account_Notifications();

            foreach (self::NEW_TABS as $tabKey => $tabName) {
                add_action("woocommerce_account_{$tabKey}_endpoint", [$this, "{$tabKey}TabContent"]);
            }

            add_action("woocommerce_account_favorite-products_endpoint", [$this, "favoriteProductsTabContent"]);
            add_action("woocommerce_account_favorite-posts_endpoint", [$this, "favoritePostsTabContent"]);

            add_action('init', [$this, 'customTabsEndPoints']);

            // Change Orders
            add_filter('woocommerce_account_menu_items', [$this, 'customMenuOrder'], 999);

            // Remove Comment
            add_action('wp_ajax_accountino_delete_comment', [$this, 'deleteComment']);
            add_action('wp_ajax_nopriv_accountino_delete_comment', [$this, 'deleteComment']);

            // Customize Address Fields
            add_filter('woocommerce_default_address_fields', [$this, 'customAddressFields'], 10, 2);
            add_filter('woocommerce_billing_fields', [$this, 'customBillingAddressFields'], 20, 1);
            add_filter('woocommerce_form_field', [$this, 'removeFormRowClass'], 10, 4);
            add_action('wp_footer', [$this, 'setDefaultCountry']);

            // Login Page
            add_action('template_redirect', [$this, 'templateLoginPage']);
        }

        public static function customTabsEndPoints()
        {
            foreach (self::NEW_TABS as $tabKey => $tabName) {
                add_rewrite_endpoint($tabKey, EP_ROOT | EP_PAGES);
            }

            add_rewrite_endpoint('favorite-products', EP_ROOT | EP_PAGES);
            add_rewrite_endpoint('favorite-posts', EP_ROOT | EP_PAGES);
        }

        public static function favoritesTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/favorites.php');
        }

        public static function commentsTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/comments.php');
        }

        public static function contact_supportTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/contact_support/index.php');
        }

        public static function notificationsTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/notifications.php');
        }

        public static function licensesTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/licenses.php');
        }

        public static function favoriteProductsTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/favorites/products.php');
        }

        public static function favoritePostsTabContent()
        {
            include(ACCOUNTINO_PATH . '/woocommerce/myaccount/favorites/posts.php');
        }


        public static function customMenuOrder()
        {
            return [
                'dashboard'       => 'داشبورد',
                'orders'          => 'سفارش ها',
                'downloads'       => 'دانلودها',
                'favorites'       => self::NEW_TABS['favorites'],
                'comments'        => self::NEW_TABS['comments'],
                'contact_support' => self::NEW_TABS['contact_support'],
                'edit-address'    => 'آدرس ها',
                'edit-account'    => 'اطلاعات حساب کاربری',
                'licenses'       => self::NEW_TABS['licenses'],
                'notifications'   => self::NEW_TABS['notifications'],
                'customer-logout' => 'خروج از حساب کاربری',
            ];
        }

        public static function getCurrentPageTitle($endpoint)
        {
            $getMenus = self::customMenuOrder();

            $pageTitle = null;

            if (is_array($endpoint)) {
                foreach ($endpoint as $key => $value) {
                    if (!empty($getMenus[$key])) {
                        $pageTitle = $getMenus[$key];
                        break;
                    }
                }
            } else {
                $pageTitle = $getMenus[$endpoint];
            }
            return $pageTitle;
        }


        public static function deleteComment()
        {
            if (!isset($_POST['comment_id']) || !isset($_POST['user_id'])) wp_die();

            $commentId = sanitize_text_field($_POST['comment_id']);
            $userId = sanitize_text_field($_POST['user_id']);

            if (wp_delete_comment($commentId, $userId)) {
                wp_send_json_success();
            } else {
                wp_send_json_error();
            }
        }

        public static function customAddressFields($fields)
        {
            unset($fields['address_2']);
            unset($fields['company']);

            $fields['address_1']['placeholder'] = null;
            $fields['address_1']['label'] = 'جزئیات آدرس';
            $fields['address_1']['value'] = 'جزئیات آدرس';
            $fields['first_name']['class'] = null;
            $fields['last_name']['class'] = null;
            $fields['postcode']['priority'] = 35;
            $fields['state']['priority'] = 40;
            $fields['city']['priority'] = 45;

            return $fields;
        }

        public static function customBillingAddressFields($fields)
        {
            unset($fields['billing_email']);

            $fields['billing_phone']['required'] = true;
            $fields['billing_phone']['priority'] = 30;


            return $fields;
        }

        public function removeFormRowClass($field, $key, $args, $value)
        {
            $field = str_replace('form-row', '', $field);
            return $field;
        }
        public function setDefaultCountry()
        {
            if (is_account_page()) : ?>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const billingCountry = document.querySelector('[name="billing_country"]');
                        if (billingCountry && !billingCountry.value) {
                            billingCountry.value = 'IR';
                        }

                        const shippingCountry = document.querySelector('[name="shipping_country"]');
                        if (shippingCountry && !shippingCountry.value) {
                            shippingCountry.value = 'IR';
                        }
                    });
                </script>
<?php endif;
        }

        public static function templateLoginPage()
        {
            if (is_account_page() && !is_user_logged_in()) {
                wp_redirect(home_url('/login')); // Change 'login' to your page slug
                exit;
            }
        }

        public static function getOrderMetaData($orderItem)
        {
            $return = [];
            foreach ($orderItem->get_meta_data() as $meta) {
                $key = $meta->key;
                $cleanKey = str_replace('pa_', '', $key);
                $value = $meta->value;

                $tax_obj = get_taxonomy($key);
                $taxonomyName = $tax_obj ? $tax_obj->labels->singular_name : $cleanKey;

                $term = get_term_by('slug', $value, $key);
                $display_value = $term ? $term->name : $value;

                if (!empty($display_value)) {
                    $return[$cleanKey] = [
                        'value' => esc_html(urldecode($value)),
                        'label' => esc_html(urldecode($taxonomyName)),
                        'formatted_value' => esc_html(urldecode($display_value)),
                    ];
                }
            }
            return $return;
        }

        public static function getOrderItemTimeDuration($orderMeta, $orderDate)
        {
            if (!empty($orderMeta['duration-time'])) {
                $value = $orderMeta['duration-time']['value'];

                if (strpos($value, 'month') !== false) {
                    $type = 'month';
                } elseif (strpos($value, 'year') !== false) {
                    $type = 'year';
                } else {
                    $type = null;
                }


                $duration = (int) filter_var($value, FILTER_SANITIZE_NUMBER_INT);

                $expireDate = $daysLeft = '-';
                if (!empty($type)) {
                    $expireDate =  date('Y/m/d', strtotime("+$duration {$type}", strtotime($orderDate)));

                    if (strtotime($expireDate) > time())
                        $daysLeft = round((strtotime($expireDate) - time()) / 86400);
                }

                return [
                    'expireDate' => $expireDate,
                    'daysLeft' => $daysLeft
                ];
            }

            return [
                'expireDate' => null,
                'daysLeft' => null
            ];
        }
    }


endif;
