<?php

/**
 * Elementor class
 *
 
 */

// If Elementor plugins doesn't exist then return.
if (
    ! ACCOUNTINO_ELEMENTOR_ACTIVE
    && version_compare(PHP_VERSION, '5.6', '>=')
) {
    return;
}

if (! class_exists('Accountino_Elementor')) :

    class Accountino_Elementor
    {

        /**
         * Setup class.
         *
         * @since 1.4.0
         */
        public function __construct()
        {
            add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));
        }

        /**
         * Get the header ID.
         *
         * @since 1.4.0
         */
        public static function get_header_id()
        {

            // Template
            $id = accountino_custom_header_template();

            // If template is selected
            if (! empty($id)) {

                // Get Polylang Translation of template
                if (function_exists('pll_get_post')) {
                    $id_polylang = pll_get_post($id, pll_current_language());
                    if (! empty($id_polylang)) {
                        $id = $id_polylang;
                    }
                }

                return $id;
            }

            // Return
            return false;
        }

        /**
         * Get the footer ID.
         *
         * @since 1.4.0
         */
        public static function get_footer_id()
        {

            // Template
            $id = accountino_custom_footer_template();

            // If template is selected
            if (! empty($id)) {

                // Get Polylang Translation of template
                if (function_exists('pll_get_post')) {
                    $id_polylang = pll_get_post($id, pll_current_language());
                    if (! empty($id_polylang)) {
                        $id = $id_polylang;
                    }
                }

                return $id;
            }

            // Return
            return false;
        }

        /**
         * Get the 404 error page ID.
         *
         * @since 1.4.0
         */
        public static function get_error_page_id()
        {

            // Template
            $id = get_theme_mod('accountino_not_found_template');

            // If template is selected
            if (! empty($id)) {

                // Get Polylang Translation of template
                if (function_exists('pll_get_post')) {
                    $id_polylang = pll_get_post($id, pll_current_language());
                    if (! empty($id_polylang)) {
                        $id = $id_polylang;
                    }
                }

                return $id;
            }

            // Return
            return false;
        }

        /**
         * Enqueue styles
         *
         * @since 1.4.0
         */
        public static function enqueue_styles()
        {

            if (class_exists('\Elementor\Core\Files\CSS\Post')) {

                $header_id                     = self::get_header_id();
                $footer_id                     = self::get_footer_id();
                $error_id                     = self::get_error_page_id();

                // Enqueue header css file
                if (false != $header_id) {
                    $header_css = new \Elementor\Core\Files\CSS\Post($header_id);
                    $header_css->enqueue();
                }

                // Enqueue footer css file
                if (false != $footer_id) {
                    $footer_css = new \Elementor\Core\Files\CSS\Post($footer_id);
                    $footer_css->enqueue();
                }

                // Enqueue 404 error page css file
                if (false != $error_id) {
                    $error_css = new \Elementor\Core\Files\CSS\Post($error_id);
                    $error_css->enqueue();
                }
            }
        }

        /**
         * Prints the header content.
         *
         * @since 1.4.0
         */
        public static function get_header_content()
        {
            echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display(self::get_header_id());
        }

        /**
         * Prints the footer content.
         *
         * @since 1.4.0
         */
        public static function get_footer_content()
        {
            echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display(self::get_footer_id());
        }

        /**
         * Prints the 404 error page content.
         *
         * @since 1.4.0
         */
        public static function get_error_page_content()
        {
            echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display(self::get_error_page_id());
        }

        /**
         * Prints the custom page content.
         *
         * @since 1.4.0
         */
        public static function get_page_content($pageId)
        {
            return Elementor\Plugin::instance()->frontend->get_builder_content_for_display($pageId);
        }
    }

endif;

return new Accountino_Elementor();
