<?php

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Aria Theme
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once ACCOUNTINO_PATH . '/includes/tgm/class-tgm-plugin-activation.php';

add_action('tgmpa_register', 'aria_theme_register_required_plugins');

function aria_theme_register_required_plugins()
{
    $plugins = array(


        array(
            'name'     =>  __('Elementor', 'accountino'),
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'     =>  __('Woocomerce', 'accountino'),
            'slug'     => 'woocommerce',
            'required' => true,
        ),
        array(
            'name'               => 'AccountPro Core', // The plugin name.
            'slug'               => 'accountpro-core', // The plugin slug (typically the folder name).
            'source'             => get_template_directory() . '/plugins/accountpro-core.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '1.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
        ),

    );

    $config = array(
        'id'           => 'accountino',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'accountino-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => __('افزونه‌های مورد نیاز را نصب کنید', 'accountino'),
            'menu_title'                      => __('نصب افزونه‌ها', 'accountino'),
            'installing'                      => __('نصب افزونه: %s', 'accountino'),
            'updating'                        => __('به‌روزرسانی افزونه: %s', 'accountino'),
            'oops'                            => __('مشکلی در API افزونه پیش آمده است.', 'accountino'),
            'notice_can_install_required'     => _n_noop(
                'این قالب به افزونه زیر نیاز دارد: %1$s.',
                'این قالب به افزونه‌های زیر نیاز دارد: %1$s.',
                'accountino'
            ),
            'notice_can_install_recommended'  => _n_noop(
                'این قالب افزونه زیر را توصیه می‌کند: %1$s.',
                'این قالب افزونه‌های زیر را توصیه می‌کند: %1$s.',
                'accountino'
            ),
            'notice_ask_to_update'            => _n_noop(
                'افزونه زیر باید به آخرین نسخه خود به‌روزرسانی شود تا از حداکثر سازگاری با این قالب اطمینان حاصل شود.: %1$s.',
                'افزونه‌های زیر باید به آخرین نسخه خود به‌روزرسانی شوند تا از حداکثر سازگاری با این قالب اطمینان حاصل شود.: %1$s.',
                'accountino'
            ),
            'notice_ask_to_update_maybe'      => _n_noop(
                'یک به‌روزرسانی برای آن موجود است: %1$s.',
                'به‌روزرسانی‌هایی برای افزونه‌های زیر موجود است: %1$s.',
                'accountino'
            ),
            'notice_can_activate_required'    => _n_noop(
                'افزونه مورد نیاز زیر در حال حاضر غیرفعال است: %1$s.',
                'افزونه‌های مورد نیاز زیر در حال حاضر غیرفعال هستند.: %1$s.',
                'accountino'
            ),
            'notice_can_activate_recommended' => _n_noop(
                'افزونه پیشنهادی زیر در حال حاضر غیرفعال است: %1$s.',
                'افزونه‌های پیشنهادی زیر در حال حاضر غیرفعال هستند.: %1$s.',
                'accountino'
            ),
            'install_link'                    => _n_noop(
                'شروع نصب افزونه',
                'شروع نصب افزونه‌ها',
                'accountino'
            ),
            'update_link'                       => _n_noop(
                'شروع به‌روزرسانی افزونه',
                'شروع به روزرسانی افزونه ها',
                'accountino'
            ),
            'activate_link'                   => _n_noop(
                'شروع فعال‌سازی افزونه',
                'شروع فعال‌سازی افزونه‌ها',
                'accountino'
            ),
            'return'                          => __('بازگشت به نصب‌کننده افزونه‌های مورد نیاز', 'accountino'),
            'plugin_activated'                => __('افزونه با موفقیت فعال شد.', 'accountino'),
            'activated_successfully'          => __('افزونه زیر با موفقیت فعال شد.:', 'accountino'),
            'plugin_already_active'           => __('هیچ اقدامی انجام نشد. افزونه %1$s از قبل فعال بود..', 'accountino'),
            'plugin_needs_higher_version'     => __('افزونه فعال نشد. برای این قالب به نسخه بالاتری از %s نیاز است. لطفاً افزونه را به‌روزرسانی کنید..', 'accountino'),
            'complete'                        => __('همه افزونه‌ها با موفقیت نصب و فعال شدند. %1$s', 'accountino'),
            'dismiss'                         => __('این اطلاعیه را رد کنید', 'accountino'),
            'notice_cannot_install_activate'  => __('یک یا چند افزونه مورد نیاز یا توصیه شده برای نصب، به‌روزرسانی یا فعال‌سازی وجود دارد.', 'accountino'),
            'contact_admin'                   => __('لطفا برای راهنمایی با مدیر این سایت تماس بگیرید.', 'accountino'),
        ),
    );

    tgmpa($plugins, $config);
}
