<?php

if (! class_exists('Accountino_Shamsi_Date_Service')) :

    class Accountino_Shamsi_Date_Service
    {

        public function __construct()
        {

            add_filter('get_the_date', function ($date, $format) {
                $date = str_replace('.', '-', $date);
                return self::convertToJalali(strtotime($date), '.');
            }, 10, 2);

            add_filter('get_the_time', function ($date, $format) {
                return self::convertToJalali(strtotime($date), '.');
            }, 10, 2);

            add_filter('get_comment_date', function ($date, $format) {
                $date = str_replace('.', '-', $date);
                return self::convertToJalali(strtotime($date), '.');
            }, 10, 2);

            add_filter('woocommerce_order_date', function ($date_str, $order) {
                $timestamp = strtotime($order->get_date_created());
                return self::convertToJalali($timestamp);
            }, 10, 2);

            add_filter('wc_format_datetime', function ($date_str) {
                echo $date_str;
                die();
                return self::convertToJalali(strtotime($date_str));
            }, 10);
        }



        private static function gregorianToJalali($gy, $gm, $gd, $sep = '-')
        {
            $g_days_in_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
            $j_days_in_month = [31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29];

            $gy = $gy - 1600;
            $gm = $gm - 1;
            $gd = $gd - 1;

            $g_day_no = 365 * $gy + floor(($gy + 3) / 4) - floor(($gy + 99) / 100) + floor(($gy + 399) / 400);
            for ($i = 0; $i < $gm; ++$i)
                $g_day_no += $g_days_in_month[$i];
            if ($gm > 1 && (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)))
                $g_day_no++;

            $g_day_no += $gd;

            $j_day_no = $g_day_no - 79;

            $j_np = floor($j_day_no / 12053);
            $j_day_no %= 12053;

            $jy = 979 + 33 * $j_np + 4 * floor($j_day_no / 1461);
            $j_day_no %= 1461;

            if ($j_day_no >= 366) {
                $jy += floor(($j_day_no - 1) / 365);
                $j_day_no = ($j_day_no - 1) % 365;
            }

            for ($i = 0; $i < 11 && $j_day_no >= $j_days_in_month[$i]; ++$i) {
                $j_day_no -= $j_days_in_month[$i];
            }
            $jm = $i + 1;
            $jd = $j_day_no + 1;

            return $jy . $sep . str_pad($jm, 2, '0', STR_PAD_LEFT) . $sep . str_pad($jd, 2, '0', STR_PAD_LEFT);
        }

        public static function convertToJalali($timestamp, $sep = '-')
        {
            return self::gregorianToJalali(date('Y', $timestamp), date('m', $timestamp), date('d', $timestamp), $sep);
        }

        public static function convertToJalaliWithMonth($timestamp)
        {
            $jYear = substr($timestamp, 0, 4);
            $jMonth = substr($timestamp, 5, 2);
            $jDay = substr($timestamp, 8, 2);

            list($gy, $gm, $gd) = self::jalaliToGeogorian($jYear, $jMonth, $jDay);
            return self::convertToJalaliWithMonthName($gy, $gm, $gd);
        }

        public static function convertToJalaliWithMonthName($gy, $gm, $gd)
        {
            $months = ['فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'];
            $date = self::gregorianToJalali($gy, $gm, $gd);
            list($jy, $jm, $jd) = explode('-', $date);
            return $jd . ' ' . $months[$jm - 1] . ' ' . $jy;
        }

        private static function jalaliToGeogorian($jy, $jm, $jd)
        {
            $jy += 1595;
            $days = -355668 + (365 * $jy) + intval($jy / 33) * 8 + intval(((($jy % 33) + 3) / 4));

            $jalali_days_in_month = [0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336, 366];
            $days += $jd;

            if ($jm > 1) {
                $days += $jalali_days_in_month[$jm - 1];
            }

            $gy = 400 * intval($days / 146097);
            $days %= 146097;

            if ($days > 36524) {
                $gy += 100 * intval(--$days / 36524);
                $days %= 36524;

                if ($days >= 365) {
                    $days++;
                }
            }

            $gy += 4 * intval($days / 1461);
            $days %= 1461;

            if ($days > 365) {
                $gy += intval(($days - 1) / 365);
                $days = ($days - 1) % 365;
            }

            $gm_days = [31, (checkdate(2, 29, $gy) ? 29 : 28), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
            $gm = 0;

            for ($i = 0; $i < 12 && $days >= $gm_days[$i]; $i++) {
                $days -= $gm_days[$i];
            }

            $gm = $i + 1;
            $gd = $days + 1;

            return [$gy, $gm, $gd];
        }
    }


endif;

return new Accountino_Shamsi_Date_Service();
