<?php

use Elementor\Utils;

if (! class_exists('Accountino_Post_Service')) :

    class Accountino_Post_Service
    {

        public function __construct()
        {
            // Reading Time Field
            add_action('add_meta_boxes', [$this, 'addReadingTimeBox']);
            add_action('save_post', [$this, 'saveReadingTimeField']);

            // Ajax for Favorite
            add_action('wp_ajax_accountino_post_favorite', [$this, 'postFavorite']);
            add_action('wp_ajax_nopriv_accountino_post_favorite', [$this, 'postFavorite']);
        }

        public function addReadingTimeBox()
        {
            add_meta_box(
                'accountino_reading_time',
                'اکانت پرو',
                [$this, 'renderReadingTimeMetaBox'],
                'post',
                'side',
                'default'
            );
        }

        public function renderReadingTimeMetaBox($post)
        {
            $value = get_post_meta($post->ID, '_reading_time', true);
            wp_nonce_field('save_reading_time', 'reading_time_nonce'); ?>
            <label for="reading_time">زمان مورد نیاز برای مطالعه</label>
            <input type="number" min="1" id="reading_time" name="reading_time" value="<?php echo esc_attr($value); ?>" style="width: 100%;" />
<?php
        }

        function saveReadingTimeField($post_id)
        {
            if (
                !isset($_POST['reading_time_nonce']) ||
                !wp_verify_nonce($_POST['reading_time_nonce'], 'save_reading_time')
            ) {
                return;
            }

            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

            if (isset($_POST['reading_time'])) {
                update_post_meta($post_id, '_reading_time', intval($_POST['reading_time']));
            }
        }

        public static function getPostReadingTime($postID)
        {
            return get_post_meta($postID, '_reading_time', true) ?? 0;
        }

        public static function setPostViews($postID)
        {
            $key = '_post_views_count';
            $views = get_post_meta($postID, $key, true);
            $views = $views ? (int) $views + 1 : 1;
            update_post_meta($postID, $key, $views);
        }

        public static function getPostViews($postID)
        {
            $views = get_post_meta($postID, '_post_views_count', true);
            return $views ? $views : 0;
        }

        public function postFavorite()
        {
            if (!is_user_logged_in()) {
                wp_send_json_error('not_logged_in');
            }

            $postId = absint($_POST['post_id']);
            $user_id = get_current_user_id();
            $favorites = self::getUserFavoritePosts($user_id);

            if (in_array($postId, $favorites)) {
                self::removepostFavorite($user_id, $postId);
                wp_send_json_success(['status' => 'Removed']);
            } else {
                self::addpostFavorite($user_id, $postId);
                wp_send_json_success(['status' => 'Added']);
            }
        }

        // User Favorites
        public static function getUserFavoritePosts($user_id)
        {
            return get_user_meta($user_id, 'favorite_posts', true) ?: [];
        }

        // Add favorite
        public function addpostFavorite($user_id, $postId)
        {
            $favorites = self::getUserFavoritePosts($user_id);
            if (!in_array($postId, $favorites)) {
                $favorites[] = $postId;
                update_user_meta($user_id, 'favorite_posts', $favorites);
            }
        }

        // Get Favorite Posts
        public static function favoritePosts($options = [])
        {
            $args = [
                'post_type'      => ['post', 'product'],
                'post__in'        => self::getUserFavoritePosts(get_current_user_id()),
                'post_status'    => 'publish',
            ];

            $args = array_merge($args, $options);

            return new \WP_Query($args);
        }

        // Remove favorite
        public function removepostFavorite($user_id, $postId)
        {
            $favorites = self::getUserFavoritePosts($user_id);
            if (($key = array_search($postId, $favorites)) !== false) {
                unset($favorites[$key]);
                update_user_meta($user_id, 'favorite_posts', $favorites);
            }
        }

        public static function checkPostIsFavorite($postId)
        {
            $user_id = get_current_user_id();
            $userFavorites = self::getUserFavoritePosts($user_id);


            return !empty($userFavorites) && is_array($userFavorites) && in_array($postId, $userFavorites);
        }
    }


endif;

return new Accountino_Post_Service();
