<?php

use Elementor\Utils;

if (! class_exists('Accountino_Post_Category_Service')) :

    class Accountino_Post_Category_Service
    {

        public function __construct()
        {
            // Add thumbnail selector for post categories
            add_action('category_add_form_fields', [$this, 'addFieldsCategories']);
            add_action('category_edit_form_fields', [$this, 'editFieldsCategories']);

            // Save thumbnail selector for post categories
            add_action('created_category', [$this, 'saveFieldsCategories']);
            add_action('edited_category', [$this, 'saveFieldsCategories']);

            add_action('admin_enqueue_scripts', [$this, 'loadMediaScript']);
            add_action('admin_footer', [$this, 'uploadFieldScript']);
        }

        public static function addFieldsCategories()
        {
?>
            <div class="form-field term-english-wrap">
                <label for="tag-english">نام انگلیسی</label>
                <input name="english_name" id="tag-english" type="text" value="" size="40" aria-describedby="english-description">
            </div>
            <div class="form-field">
                <label for="term_thumbnail">آیکن</label>
                <input type="hidden" name="term_thumbnail" id="term_thumbnail" value="" />
                <div id="term_thumbnail_preview" style="margin-bottom: 10px;">
                </div>
                <button type="button" class="button upload_term_thumbnail">انتخاب عکس</button>
                <button type="button" class="button remove_term_thumbnail">حذف عکس</button>
            </div>
        <?php
        }

        public static function editFieldsCategories($term)
        {
            $englishName = get_term_meta($term->term_id, '_english_name', true);
            $thumbnail_id = get_term_meta($term->term_id, '_thumbnail_id', true);
            $image_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'thumbnail') : '';
        ?>
            <tr class="form-field">
                <th><label for="tag-english">نام انگلیسی</label></th>
                <td>
                    <input name="english_name" id="tag-english" type="text" value="<?= $englishName; ?>" size="40">
                </td>
            </tr>
            <tr class="form-field">
                <th><label for="term_thumbnail">آیکن</label></th>
                <td>
                    <input type="hidden" id="term_thumbnail" name="term_thumbnail" value="<?php echo esc_attr($thumbnail_id); ?>">
                    <div id="term_thumbnail_preview">
                        <?php if ($image_url): ?>
                            <img src="<?php echo esc_url($image_url); ?>" style="max-width:100px;height:auto;">
                        <?php endif; ?>
                    </div>
                    <button type="button" class="button upload_term_thumbnail">انتخاب عکس</button>
                    <button type="button" class="button remove_term_thumbnail">حذف عکس</button>
                </td>
            </tr>
            <?php
        }

        public static function saveFieldsCategories($term_id)
        {
            if (isset($_POST['term_thumbnail'])) {
                update_term_meta($term_id, '_thumbnail_id', absint($_POST['term_thumbnail']));
            }
            if (isset($_POST['english_name'])) {
                update_term_meta($term_id, '_english_name', $_POST['english_name']);
            }
        }

        public static function loadMediaScript($hook)
        {
            $screen = get_current_screen();
            if ($screen && $screen->id === 'edit-category') {
                wp_enqueue_media();
            }
        }

        public static function uploadFieldScript()
        {
            $screen = get_current_screen();
            if ($screen && $screen->id === 'edit-category') { ?>
                <script>
                    jQuery(document).ready(function($) {
                        var mediaUploader;

                        $('.upload_term_thumbnail').on('click', function(e) {
                            e.preventDefault();

                            if (mediaUploader) {
                                mediaUploader.open();
                                return;
                            }

                            mediaUploader = wp.media({
                                title: 'انتخاب عکس',
                                button: {
                                    text: 'استفاده از عکس'
                                },
                                multiple: false
                            });

                            mediaUploader.on('select', function() {
                                var attachment = mediaUploader.state().get('selection').first().toJSON();
                                $('#term_thumbnail').val(attachment.id);
                                $('#term_thumbnail_preview').html('<img src="' + attachment?.image?.src + '" style="max-width: 100px;" />');
                            });

                            mediaUploader.open();
                        });

                        $('.remove_term_thumbnail').on('click', function() {
                            $('#term_thumbnail').val('');
                            $('#term_thumbnail_preview').empty();
                        });
                    });
                </script>
<?php
            }
        }

        public static function generatePost($post)
        {
            global $wp;
            global $post;

            $post_link = get_permalink();

            if (has_post_thumbnail()) {
                $postImage = get_the_post_thumbnail($post, 'medium');;
            } else {
                $postImage = '<img src="' . esc_url(Utils::get_placeholder_image_src()) . '" alt="Placeholder">';
            }
            $excerpt = get_the_excerpt();
            $excerpt = (!empty($excerpt) ? mb_substr(strip_tags($excerpt), 0, 35) . ' ...' : null);

            $isFavoritePage = is_account_page() || isset($wp->query_vars['favorite-posts']);

            if ($isFavoritePage) {
                $checkIsFavorite = Accountino_Post_Service::checkPostIsFavorite($post->ID);
                $favoriteHtml = '<span class="card-favorite-btn" onclick="favoritePost(' . $post->ID . '); return false;">
                <i class="fa' . (!$checkIsFavorite ? 'r' : 's') . ' fa-heart" data-id="' . $post->ID . '" data-favorite="' . ($checkIsFavorite ? "true" : "false") . '"></i>
            </span>';
            } else {
                $favoriteHtml = null;
            }

            return "<article class='accountino-blog-box'>
                    <a href='{$post_link}'>
                        <div class='accountino-blog-box-top'>
                            <div class='accountino-blog-box-top__image'>
                                {$postImage}
                                <div class='accountino-blog-box-top__shapes'></div>
                            </div>
                            <div class='accountino-blog-box-top__circle'>
                            </div>
                        </div>
                        <div class='accountino-blog-box-main card-box-main'>
                            <div class='accountino-blog-box-main__title'>
                                " . wp_kses_post(get_the_title()) . "
                            </div>
                            <div class='accountino-blog-box-main-details'>
                                <div class='accountino-blog-box-main-details__description'>
                                {$excerpt}
                                </div>
                                <div class='accountino-blog-box-main-details__date'>
                                    <svg width='13' height='14' viewBox='0 0 13 14' fill='none' xmlns='http://www.w3.org/2000/svg'>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M1.52727 2.8V12.4727H11.2V2.8H1.52727ZM0 2.54545C0 1.84255 0.569819 1.27273 1.27273 1.27273H11.4545C12.1575 1.27273 12.7273 1.84255 12.7273 2.54545V12.7273C12.7273 13.4302 12.1575 14 11.4545 14H1.27273C0.569819 14 0 13.4302 0 12.7273V2.54545Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M9.41818 0C9.83993 0 10.1818 0.341892 10.1818 0.763636V2.03636C10.1818 2.45811 9.83993 2.8 9.41818 2.8C8.99644 2.8 8.65454 2.45811 8.65454 2.03636V0.763636C8.65454 0.341892 8.99644 0 9.41818 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M3.30909 0C3.73084 0 4.07273 0.341892 4.07273 0.763636V2.03636C4.07273 2.45811 3.73084 2.8 3.30909 2.8C2.88735 2.8 2.54545 2.45811 2.54545 2.03636V0.763636C2.54545 0.341892 2.88735 0 3.30909 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M0 5.09091C0 4.66916 0.341892 4.32727 0.763636 4.32727H11.9636C12.3854 4.32727 12.7273 4.66916 12.7273 5.09091C12.7273 5.51265 12.3854 5.85455 11.9636 5.85455H0.763636C0.341892 5.85455 0 5.51265 0 5.09091Z' fill='#0EFDC2'/>
                                    </svg> " . Accountino_Shamsi_Date_Service::convertToJalaliWithMonth(get_the_date()) . "
                                </div>
                            </div>
                            <div class='accountino-blog-box-main-card'>
                                <div class='accountino-blog-box-main-details__date_responsive accountino-blog-box-main-details__date'>
                                    <svg width='13' height='14' viewBox='0 0 13 14' fill='none' xmlns='http://www.w3.org/2000/svg'>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M1.52727 2.8V12.4727H11.2V2.8H1.52727ZM0 2.54545C0 1.84255 0.569819 1.27273 1.27273 1.27273H11.4545C12.1575 1.27273 12.7273 1.84255 12.7273 2.54545V12.7273C12.7273 13.4302 12.1575 14 11.4545 14H1.27273C0.569819 14 0 13.4302 0 12.7273V2.54545Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M9.41818 0C9.83993 0 10.1818 0.341892 10.1818 0.763636V2.03636C10.1818 2.45811 9.83993 2.8 9.41818 2.8C8.99644 2.8 8.65454 2.45811 8.65454 2.03636V0.763636C8.65454 0.341892 8.99644 0 9.41818 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M3.30909 0C3.73084 0 4.07273 0.341892 4.07273 0.763636V2.03636C4.07273 2.45811 3.73084 2.8 3.30909 2.8C2.88735 2.8 2.54545 2.45811 2.54545 2.03636V0.763636C2.54545 0.341892 2.88735 0 3.30909 0Z' fill='#0EFDC2'/>
                                        <path fill-rule='evenodd' clip-rule='evenodd' d='M0 5.09091C0 4.66916 0.341892 4.32727 0.763636 4.32727H11.9636C12.3854 4.32727 12.7273 4.66916 12.7273 5.09091C12.7273 5.51265 12.3854 5.85455 11.9636 5.85455H0.763636C0.341892 5.85455 0 5.51265 0 5.09091Z' fill='#0EFDC2'/>
                                    </svg> " . Accountino_Shamsi_Date_Service::convertToJalaliWithMonth(get_the_date()) . "
                                </div>
                                <div class='accountino-blog-box-main-button'>
                                    <span class='accountino-blog-box-main__button'>
                                        مشاهده
                                    </span>
                                    {$favoriteHtml}
                                </div>
                            </div>
                        </div>
                    </a>
                </article>";
        }
    }


endif;

return new Accountino_Post_Category_Service();
