<?php

/**
 * Theme Panel
 *
 * @package Accountino
 * @category Core
 * @author Vahid Jahangir
 */
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Start Class
class Accountino_Theme_Panel
{

    /**
     * Start things up
     */
    public function __construct()
    {
        require_once ACCOUNTINO_PATH . '/includes/panel/library.php';
        require_once ACCOUNTINO_PATH . '/includes/panel/library-shortcode.php';


        // Add panel menu
        add_action('admin_menu', array('Accountino_Theme_Panel', 'add_page'), 0);

        // Add panel submenu
        add_action('admin_menu', array('Accountino_Theme_Panel', 'add_menu_subpage'));

        // Add custom CSS for the theme panel
        add_action('admin_enqueue_scripts', array('Accountino_Theme_Panel', 'css'));

        // Register panel settings
        add_action('admin_init', array('Accountino_Theme_Panel', 'register_settings'));
    }

    /**
     * Return customizer options
     *
     * @since 1.0.8
     */
    private static function get_options()
    {

        $options = array(
            'custom_logo' => array(
                'label' => esc_html__('لوگوی خود را آپلود کنید', 'accountino'),
                'desc' => esc_html__('لوگوی خود و لوگوی رتینا که برای صفحات رتینا استفاده می‌شود را اضافه کنید.', 'accountino'),
            ),
            'site_icon' => array(
                'label' => esc_html__('فاوآیکون خود را اضافه کنید', 'accountino'),
                'desc' => esc_html__('فاوآیکون به عنوان آیکون مرورگر و اپلیکیشن برای وب‌سایت شما استفاده می‌شود.', 'accountino'),
            ),
            'primary_color' => array(
                'label' => esc_html__('رنگ اصلی خود را انتخاب کنید', 'accountino'),
                'desc' => esc_html__('رنگ اصلی و رنگ شناور پیش‌فرض را با رنگ‌های دلخواه خود جایگزین کنید.', 'accountino'),
                'elementor' => true
            ),
            'typography' => array(
                'label' => esc_html__('تایپوگرافی خود را انتخاب کنید', 'accountino'),
                'desc' => esc_html__('تایپوگرافی دلخواه خود را برای هر بخش از وب‌سایت خود انتخاب کنید.', 'accountino'),
                'elementor' => true
            ),
            'accountino_header_style' => array(
                'label' => esc_html__('تنظیمات هدر', 'accountino'),
                'desc' => esc_html__('قالب هدر خود را انتخاب کنید.', 'accountino'),
            ),
            'accountino_footer_style' => array(
                'label' => esc_html__('تنظیمات فوتر', 'accountino'),
                'desc' => esc_html__('قالب فوتر خود را انتخاب کنید.', 'accountino'),
            ),
            'accountino_custom_js_section' => array(
                'label' => esc_html__('JS اضافی', 'accountino'),
                'desc' => esc_html__('کدهای جاوااسکریپت مورد نظر را وارد کنید.', 'accountino'),
            ),
            'section-custom_css' => array(
                'label' => esc_html__('CSS اضافی', 'accountino'),
                'desc' => esc_html__('کدهای CSS مورد نظر را وارد کنید.', 'accountino'),
            ),
        );

        // Apply filters and return
        return apply_filters('oe_customizer_options', $options);
    }

    /**
     * Registers a new menu page
     *
     * @since 1.0.0
     */
    public static function add_page()
    {
        add_menu_page(
            esc_html__('پنل قالب اکانت پرو', 'accountino'),
            esc_html__('پنل قالب اکانت پرو', 'accountino'),
            apply_filters('accountino_theme_panel_capabilities', 'manage_options'),
            'accountino-panel',
            '',
            'dashicons-admin-generic',
            null
        );
    }

    /**
     * Registers a new submenu page
     *
     * @since 1.0.0
     */
    public static function add_menu_subpage()
    {
        add_submenu_page(
            'accountino-general',
            esc_html__('عمومی', 'accountino'),
            esc_html__('عمومی', 'accountino'),
            apply_filters('accountino_theme_panel_capabilities', 'manage_options'),
            'accountino-panel',
            array('Accountino_Theme_Panel', 'create_admin_page')
        );
    }

    /**
     * Register a setting and its sanitization callback.
     *
     * @since 1.0.0
     */
    public static function register_settings()
    {
        register_setting('oe_panels_settings', 'oe_panels_settings', array('Accountino_Theme_Panel', 'validate_panels'));
        register_setting('accountino_options', 'accountino_options', array('Accountino_Theme_Panel', 'admin_sanitize_license_options'));
    }

    /**
     * Validate Settings Options
     * 
     * @since 1.0.0
     */
    public static function admin_sanitize_license_options($input)
    {
        if (current_user_can('manage_options')) {
            // filter to save all settings to database
            $accountino_options = get_option('accountino_options');
            if (isset($input['licenses']) && !empty($input['licenses'])) {
                foreach ($input['licenses'] as $key => $value) {
                    if ($accountino_options['licenses'][$key]) {
                        if (strpos($value, "XXX") !== FALSE && isset($accountino_options['licenses'][$key])) {
                            $input['licenses'][$key] = $accountino_options['licenses'][$key];
                        }
                    }
                }
            }

            return $input;
        }
    }

    /**
     * Main Sanitization callback
     *
     * @since 1.2.2
     */
    public static function validate_panels($settings)
    {

        // Get panels array
        $panels = self::get_panels();
        if (current_user_can('manage_options') && isset($_POST['_wpnonce']) && wp_verify_nonce($_POST['_wpnonce'], 'oe_panels_settings-options')) {

            foreach ($panels as $key => $val) {

                $settings[$key] = !empty($settings[$key]) ? true : false;
            }
        }

        // Return the validated/sanitized settings
        return $settings;
    }

    /**
     * Get settings.
     *
     * @since 1.2.2
     */
    public static function get_setting($option = '')
    {

        $defaults = self::get_default_settings();

        $settings = wp_parse_args(get_option('oe_panels_settings', $defaults), $defaults);

        return isset($settings[$option]) ? $settings[$option] : false;
    }



    /**
     * Settings page output
     *
     * @since 1.0.0
     */
    public static function create_admin_page()
    {

        // Get options array
        $options = self::get_options();
?>

        <div class="wrap accountino-theme-panel clr">

            <h1><?php esc_attr_e('پنل قالب اکانت پرو', 'accountino'); ?></h1>

            <div class="accountino-settings clr">

                <div class="left clr">


                    <div class="accountino-options clr">

                        <p class="accountino-desc"><?php esc_html_e('نگاهی به گزینه‌های سفارشی‌سازی بیندازید و ببینید که چقدر آسان و سریع می‌توانید وب‌سایت خود را مطابق میل خود سفارشی کنید.', 'accountino'); ?></p>

                        <div class="options-inner clr">

                            <?php
                            // Loop through options
                            foreach ($options as $key => $val) :

                                // Var
                                $label = isset($val['label']) ? $val['label'] : '';
                                $desc = isset($val['desc']) ? $val['desc'] : '';
                                $isElementor = isset($val['elementor']) ? $val['elementor'] : false;
                                $id = $key;
                            ?>
                                <div class="column-wrap">

                                    <div class="column-inner clr">

                                        <h3 class="title"><?php echo esc_attr($label); ?></h3>
                                        <?php if ($desc) { ?>
                                            <p class="desc"><?php echo esc_attr($desc); ?></p>
                                        <?php } ?>

                                        <div class="bottom-column">
                                            <a class="option-link" href="<?php echo $isElementor ? wp_nonce_url('post.php?post=' . get_option('elementor_active_kit') . '&action=elementor') : esc_url(admin_url('customize.php?autofocus[control]=' . $id . '')); ?>" target="_blank"><?php esc_html_e('برو به تنظیمات', 'accountino'); ?></a>
                                        </div>

                                    </div>

                                </div>

                            <?php endforeach; ?>

                        </div><!-- .options-inner -->

                    </div>

                </div>

            </div>
        </div>

<?php
    }

    /**
     * Theme panel CSS
     *
     * @since 1.0.0
     */
    public static function css($hook)
    {

        // CSS
        wp_enqueue_style('accouninto', ACCOUNTINO_STYLE_URL . 'panel.css');
    }
}

new Accountino_Theme_Panel();
