<?php

/**
 * Custom header style template
 *
 * @since 1.4.0
 */
if (! function_exists('accountino_custom_header_template')) {

    function accountino_custom_header_template()
    {

        // Get template from customizer setting
        $template = get_theme_mod('accountino_header_template');

        // Apply filters and return
        return apply_filters('accountino_custom_header_template', $template);
    }
}

/**
 * Custom footer style template
 *
 * @since 1.4.0
 */
if (! function_exists('accountino_custom_footer_template')) {

    function accountino_custom_footer_template()
    {

        // Get template from customizer setting
        $template = get_theme_mod('accountino_footer_template');

        // Apply filters and return
        return apply_filters('accountino_custom_footer_template', $template);
    }
}

/**
 * Custom footer style template
 *
 * @since 1.4.0
 */
if (! function_exists('accountino_custom_not_found_template')) {

    function accountino_custom_not_found_template()
    {

        // Get template from customizer setting
        $template = get_theme_mod('accountino_not_found_template');

        // Apply filters and return
        return apply_filters('accountino_custom_not_found_template', $template);
    }
}


/**
 * Returns header template content
 *
 * @since 1.1.1
 */
if (! function_exists('accountino_header_template_content')) {

    function accountino_header_template_content()
    {

        // Get the template ID
        $content = accountino_custom_header_template();

        // Get template content
        if (! empty($content)) {

            $template = get_post($content);

            if ($template && ! is_wp_error($template)) {
                $content = $template->post_content;
            }
        }

        // Apply filters and return content
        return apply_filters('accountino_header_template_content', $content);
    }
}


/**
 * Returns footer template content
 *
 * @since 1.1.1
 */
if (! function_exists('accountino_footer_template_content')) {

    function accountino_footer_template_content()
    {

        // Get the template ID
        $content = accountino_custom_footer_template();

        // Get template content
        if (! empty($content)) {

            $template = get_post($content);

            if ($template && ! is_wp_error($template)) {
                $content = $template->post_content;
            }
        }

        // Apply filters and return content
        return apply_filters('accountino_footer_template_content', $content);
    }
}


/**
 * Returns footer template content
 *
 * @since 1.1.1
 */
if (! function_exists('accountino_not_found_template_content')) {

    function accountino_not_found_template_content()
    {

        // Get the template ID
        $content = accountino_custom_not_found_template();

        // Get template content
        if (! empty($content)) {

            $template = get_post($content);

            if ($template && ! is_wp_error($template)) {
                $content = $template->post_content;
            }
        }

        // Apply filters and return content
        return apply_filters('accountino_not_found_template_content', $content);
    }
}


function convert_to_persian_digits($string)
{
    $en = range(0, 9);
    $fa = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    return str_replace($en, $fa, $string);
}


function translateRole($role)
{
    $roles_map = [
        'administrator' => esc_html('مدیر سایت'),
        'editor'        => esc_html('ویرایش کننده'),
        'author'        => esc_html('نویسنده'),
        'subscriber'    => esc_html('مشترک'),
        'customer'      => esc_html('مشتری'),
        'shop_manager'  => esc_html('مدیر فروشگاه'),
    ];

    return $roles_map[$role];
}


function getTextWordByWord($text)
{
    $textSeparated = null;
    if (strpos($text, ' ') !== false) {
        $textExploded = array_filter(explode(' ', $text));
        $textSeparated = "<span>" . implode('</span> <span>', $textExploded) . "</span>";
    } else {
        $textSeparated = "<span>{$text}</span>";
    }

    return $textSeparated;
}


function accountino_jalali_date($date)
{
    $date = str_replace('.', '-', $date);
    return Accountino_Shamsi_Date_Service::convertToJalali(strtotime($date), '.');
}
