<?php

/**
 * Elementor Fonts class
 */

if (! class_exists('Accountino_Fonts')) :

    class Accountino_Fonts
    {

        const ADDITIONAL_FONTS = [
            'YekanBakh',
            'Morabba',
            'Stretch Pro',
        ];

        public function __construct()
        {
            add_filter('elementor/fonts/groups', function ($font_groups) {
                $font_groups['advanced_fonts'] = esc_html__('فونت های سفارشی');

                return $font_groups;
            }, 10, 1);


            add_action('elementor/fonts/additional_fonts', array($this, 'additionalFonts'), 10, 1);
        }

        public function additionalFonts($fonts)
        {
            foreach (self::ADDITIONAL_FONTS as $font) {
                $fontName = strtolower(str_replace(' ', '-', $font)) . '-font';
                wp_enqueue_style(
                    $fontName,
                    ACCOUNTINO_ASSETS_URL . "fonts/{$fontName}}/{$fontName}.css",
                    [],
                    null
                );
                $fonts[$font] = 'advanced_fonts';
            }

            return $fonts;
        }
    }

endif;

return new Accountino_Fonts();
