<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Settings for header
 */

class Accountino_Customizer_Woocommerce
{

    /**
     * Setup class.
     *
     * @since 1.0
     */
    public function __construct()
    {
        add_action('customize_register', array($this, 'customizer_options'));
        add_action('customize_controls_enqueue_scripts', function () {
            wp_enqueue_script('accountino-woocommerce-customizer', ACCOUNTINO_SCRIPTS_URL . 'woocommerce-customizer.js', ['jquery', 'customize-controls'], null, true);
        });
    }

    /**
     * Customizer options
     *
     * @param WP_Customize_Manager $wp_customize Reference to WP_Customize_Manager.
     * @since 1.0.0
     */
    public function customizer_options($wp_customize)
    {

        /**
         * Section
         */
        $section = 'accountino_woocommerce';
        $wp_customize->add_section(
            $section,
            array(
                'title'    => esc_html__('تنظیمات ووکامرس', 'accountino'),
                'priority' => 20,
            )
        );


        // Parent setting
        $wp_customize->add_setting('accountino_woo_enable_archive_sidebar', [
            'default'   => false,
            'transport' => 'refresh',
        ]);

        $wp_customize->add_control('accountino_woo_enable_archive_sidebar', [
            'label'    => esc_html__('فعال سازی سایدبار برای صفحه محصولات', 'accountino'),
            'section'  => $section,
            'type'     => 'checkbox',
        ]);

        /**
         * Custom Header Template
         */
        $wp_customize->add_setting('accountino_archive_sidebar_template', array(
            'default'               => '0',
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'accountino_archive_sidebar_template', array(
            'label'                       => esc_html__('انتخاب قالب المنتور ', 'accountino'),
            'description'               => esc_html__('یک قالب ایجاد شده در پنل قالب اکانت پرو > کتابخانه من را انتخاب کنید.', 'accountino'),
            'type'                     => 'select',
            'section'                  => $section,
            'settings'                 => 'accountino_archive_sidebar_template',
            'priority'                 => 10,
            'choices'                 => accountino_customizer_helpers('library'),
            'input_attrs' => [
                'class' => 'archive-sidebar-template'
            ]
        )));
    }
}


new Accountino_Customizer_Woocommerce();
