<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Settings for header
 */

class Accountino_Customizer_Not_Found
{

    /**
     * Setup class.
     *
     * @since 1.0
     */
    public function __construct()
    {
        add_action('customize_register', array($this, 'customizer_options'));
    }

    /**
     * Customizer options
     *
     * @param WP_Customize_Manager $wp_customize Reference to WP_Customize_Manager.
     * @since 1.0.0
     */
    public function customizer_options($wp_customize)
    {

        /**
         * Section
         */
        $section = 'accountino_not_found';
        $wp_customize->add_section(
            $section,
            array(
                'title'    => esc_html__('تنظیمات صفحه 404', 'accountino'),
                'priority' => 20,
            )
        );

        /**
         * Custom Header Template
         */
        $wp_customize->add_setting('accountino_not_found_template', array(
            'default'               => '0',
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'accountino_not_found_template', array(
            'label'                       => esc_html__('انتخاب قالب المنتور ', 'accountino'),
            'description'               => esc_html__('یک قالب ایجاد شده در پنل قالب اکانت پرو > کتابخانه من را انتخاب کنید.', 'accountino'),
            'type'                     => 'select',
            'section'                  => $section,
            'settings'                 => 'accountino_not_found_template',
            'priority'                 => 10,
            'choices'                 => accountino_customizer_helpers('library'),
        )));
    }
}


new Accountino_Customizer_Not_Found();
