<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Settings for header
 */

class Accountino_Customizer_Header
{

    /**
     * Setup class.
     *
     * @since 1.0
     */
    public function __construct()
    {
        add_action('customize_register', array($this, 'customizer_options'));
    }

    /**
     * Customizer options
     *
     * @param WP_Customize_Manager $wp_customize Reference to WP_Customize_Manager.
     * @since 1.0.0
     */
    public function customizer_options($wp_customize)
    {

        /**
         * Section
         */
        $section = 'accountino_header_general';
        $wp_customize->add_section(
            $section,
            array(
                'title'    => esc_html__('تنظیمات هدر', 'accountino'),
                'priority' => 10,
            )
        );

        /**
         * Custom Header Template
         */
        $wp_customize->add_setting('accountino_header_template', array(
            'default'               => '0',
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'accountino_header_template', array(
            'label'                       => esc_html__('انتخاب قالب المنتور ', 'accountino'),
            'description'               => esc_html__('یک قالب ایجاد شده در پنل قالب اکانت پرو > کتابخانه من را انتخاب کنید.', 'accountino'),
            'type'                     => 'select',
            'section'                  => $section,
            'settings'                 => 'accountino_header_template',
            'priority'                 => 10,
            'choices'                 => accountino_customizer_helpers('library'),
        )));

        /**
         * Header Full Width
         */
        $wp_customize->add_setting('accountino_header_full_width', array(
            'transport'             => 'postMessage',
            'default'               => false,
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'accountino_header_full_width', array(
            'label'                       => esc_html__('هدر با تمام عرض صفحه', 'accountino'),
            'type'                     => 'checkbox',
            'section'                  => $section,
            'settings'                 => 'accountino_header_full_width',
            'priority'                 => 10,
        )));
    }
}


new Accountino_Customizer_Header();
