<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Settings for header
 */

class Accountino_Customizer_Footer
{

    /**
     * Setup class.
     *
     * @since 1.0
     */
    public function __construct()
    {
        add_action('customize_register', array($this, 'customizer_options'));
    }

    /**
     * Customizer options
     *
     * @param WP_Customize_Manager $wp_customize Reference to WP_Customize_Manager.
     * @since 1.0.0
     */
    public function customizer_options($wp_customize)
    {

        /**
         * Section
         */
        $section = 'accountino_footer_general';
        $wp_customize->add_section(
            $section,
            array(
                'title'    => esc_html__('تنظیمات فوتر', 'accountino'),
                'priority' => 10,
            )
        );

        /**
         * Fixed Footer
         */

        $wp_customize->add_setting(
            'accountino_fixed_footer',
            array(
                'default'           => 'off',
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'accountino_fixed_footer',
                array(
                    'label'           => esc_html__('فوتر ثابت', 'accountino'),
                    'description'     => esc_html__('این گزینه به محتوای شما ارتفاع اضافه می‌کند تا فوتر در پایین صفحه قرار گیرد.', 'accountino'),
                    'type'            => 'select',
                    'section'         => $section,
                    'settings'        => 'accountino_fixed_footer',
                    'priority'        => 10,
                    'choices'         => array(
                        'on'  => esc_html__('فعال', 'accountino'),
                        'off' => esc_html__('غیرفعال', 'accountino'),
                    ),
                )
            )
        );

        /**
         * Parallax Footer Effect
         */

        $wp_customize->add_setting(
            'accountino_parallax_footer',
            array(
                'default'           => 'off',
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'accountino_parallax_footer',
                array(
                    'label'           => esc_html__('افکت پارالکس فوتر', 'accountino'),
                    'description'     => esc_html__('یک افکت پارالاکس به فوتر خود اضافه کنید.', 'accountino'),
                    'type'            => 'select',
                    'section'         => $section,
                    'settings'        => 'accountino_parallax_footer',
                    'priority'        => 10,
                    'choices'         => array(
                        'on'  => esc_html__('فعال', 'accountino'),
                        'off' => esc_html__('غیرفعال', 'accountino'),
                    ),
                )
            )
        );

        /**
         * Footer Template
         */
        $wp_customize->add_setting(
            'accountino_footer_template',
            array(
                'default'           => '0',
            )
        );

        $wp_customize->add_control(
            new WP_Customize_Control(
                $wp_customize,
                'accountino_footer_template',
                array(
                    'label'           => esc_html__('انتخاب قالب المنتور', 'accountino'),
                    'description'     => esc_html__('یک قالب ایجاد شده در پنل قالب اکانت پرو > کتابخانه من را انتخاب کنید.', 'accountino'),
                    'type'            => 'select',
                    'section'         => $section,
                    'settings'        => 'accountino_footer_template',
                    'priority'        => 10,
                    'choices'         => accountino_customizer_helpers('library'),
                )
            )
        );

        /**
         * Footer Full Width
         */
        $wp_customize->add_setting('accountino_footer_full_width', array(
            'transport'             => 'postMessage',
            'default'               => false,
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'accountino_footer_full_width', array(
            'label'                       => esc_html__('فوتر با تمام عرض صفحه', 'accountino'),
            'type'                     => 'checkbox',
            'section'                  => $section,
            'settings'                 => 'accountino_footer_full_width',
            'priority'                 => 10,
        )));
    }
}

return new Accountino_Customizer_Footer();
