<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Settings for header
 */

class Accountino_Customizer_Custom_Js
{

    /**
     * Setup class.
     *
     * @since 1.0
     */
    public function __construct()
    {
        add_action('customize_register', array($this, 'customizer_options'));
    }

    /**
     * Customizer options
     *
     * @param WP_Customize_Manager $wp_customize Reference to WP_Customize_Manager.
     * @since 1.0.0
     */
    public function customizer_options($wp_customize)
    {

        /**
         * Section
         */
        $section = 'accountino_custom_js_section';
        $wp_customize->add_section(
            $section,
            array(
                'title'    => esc_html__('JS اضافی', 'accountino'),
                'priority' => 220,
            )
        );

        /**
         * Parallax Footer Effect
         */

        $wp_customize->add_setting(
            'accountino_custom_js',
            array(
                'default'           => '',
            )
        );

        $wp_customize->add_control(new WP_Customize_Code_Editor_Control($wp_customize, 'accountino_custom_js', [
            'label'       => esc_html__('جاوااسکریپت اضافه', 'accountino'),
            'description'       => esc_html__('کد JS خود را در اینجا اضافه نمایید.<br>بجای $ از jQuery استفاده نمایید.', 'accountino'),
            'section'     => $section,
            'settings'    => 'accountino_custom_js',
            'code_type'   => 'javascript',
        ]));
    }
}

return new Accountino_Customizer_Custom_Js();
