<?php

/**
 * The template for displaying the header
 *
 * This is the template that displays all of the <head> section, opens the <body> tag and adds the site's header.
 *
 * @package Accountino
 */
if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$viewport_content = apply_filters('accountino_viewport_content', 'width=device-width, initial-scale=1');
$skip_link_url = apply_filters('accountino_skip_link_url', '#content');
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="<?php echo esc_attr($viewport_content); ?>">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<?php
	if (! function_exists('elementor_theme_do_location') || ! elementor_theme_do_location('header')) {
		get_template_part('template-parts/header');
	}
	?>

	<?php include ACCOUNTINO_PATH . '/partials/breadcrumb.php'; ?>