<?php

/**
 * Theme functions and definitions
 *
 * @package Accountino
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

define('ACCOUNTINO_VERSION', '1.1.0');
define('THEME_TEXT_DOMAIN', 'accountino');

define('ACCOUNTINO_PATH', get_template_directory());
define('ACCOUNTINO_URL', get_template_directory_uri());
define('ACCOUNTINO_ASSETS_PATH', ACCOUNTINO_PATH . '/assets/');
define('ACCOUNTINO_ASSETS_URL', ACCOUNTINO_URL . '/assets/');
define('ACCOUNTINO_SCRIPTS_PATH', ACCOUNTINO_ASSETS_PATH . 'js/');
define('ACCOUNTINO_SCRIPTS_URL', ACCOUNTINO_ASSETS_URL . 'js/');
define('ACCOUNTINO_STYLE_PATH', ACCOUNTINO_ASSETS_PATH . 'css/');
define('ACCOUNTINO_STYLE_URL', ACCOUNTINO_ASSETS_URL . 'css/');
define('ACCOUNTINO_IMAGES_PATH', ACCOUNTINO_ASSETS_PATH . 'images/');
define('ACCOUNTINO_IMAGES_URL', ACCOUNTINO_ASSETS_URL . 'images/');
define('ACCOUNTINO_ELEMENTOR_ACTIVE', class_exists('Elementor\Plugin'));


if (! function_exists('accountino_elementor_setup')) {
    /**
     * Set up theme support.
     *
     * @return void
     */
    function accountino_elementor_setup()
    {
        register_nav_menus(['main-menu' => esc_html__('منو اصلی', 'accountino')]);

        add_post_type_support('page', 'excerpt');

        add_theme_support('post-thumbnails');
        add_theme_support('automatic-feed-links');
        add_theme_support('title-tag');
        add_theme_support(
            'html5',
            [
                'search-form',
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
                'script',
                'style',
            ]
        );
        add_theme_support(
            'custom-logo',
            [
                'height'      => 100,
                'width'       => 350,
                'flex-height' => true,
                'flex-width'  => true,
            ]
        );
        add_theme_support('align-wide');
        add_theme_support('responsive-embeds');

        add_theme_support('widgets');

        register_sidebar([
            'name'          => esc_html__('نوار کناری اصلی', 'accountino'),
            'id'            => 'sidebar-1',
            'description'   => esc_html__('نوار کناری اصلی.', 'accountino'),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ]);

        add_theme_support('woocommerce');
    }
}
add_action('after_setup_theme', 'accountino_elementor_setup');


if (! function_exists('accountino_scripts_styles')) {
    function accountino_scripts_styles()
    {
        $min_suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';


        // Main Stylesheet
        if (apply_filters('accountino_enqueue_style', true)) {
            wp_enqueue_style(
                'accountino-main',
                ACCOUNTINO_STYLE_URL . "style{$min_suffix}.css",
                [],
                ACCOUNTINO_VERSION
            );
        }

        // Custom Scripts
        wp_enqueue_script(
            'accountino-scripts',
            ACCOUNTINO_SCRIPTS_URL . "script{$min_suffix}.js",
            [],
            ACCOUNTINO_VERSION
        );

        // Font Awesome
        wp_enqueue_style('font-awesome', ACCOUNTINO_ASSETS_URL . 'fonts/fontawesome/css/font-awesome.min.css');
        wp_enqueue_style('font-awesome-icons', ACCOUNTINO_ASSETS_URL . 'fonts/fontawesome/css/all.min.css');
    }
}
add_action('wp_enqueue_scripts', 'accountino_scripts_styles');

if (! function_exists('accountino_content_width')) {
    /**
     * Set default content width.
     *
     * @return void
     */
    function accountino_content_width()
    {
        $GLOBALS['content_width'] = apply_filters('accountino_content_width', 800);
    }
}
add_action('after_setup_theme', 'accountino_content_width', 0);

if (! function_exists('accountino_add_description_meta_tag')) {
    /**
     * Add description meta tag with excerpt text.
     *
     * @return void
     */
    function accountino_add_description_meta_tag()
    {
        if (! apply_filters('accountino_description_meta_tag', true)) {
            return;
        }

        if (! is_singular()) {
            return;
        }

        $post = get_queried_object();
        if (empty($post->post_excerpt)) {
            return;
        }

        echo '<meta name="description" content="' . esc_attr(wp_strip_all_tags($post->post_excerpt)) . '">' . "\n";
    }
}
add_action('wp_head', 'accountino_add_description_meta_tag');

// Helpers page
require_once ACCOUNTINO_PATH . '/includes/helpers.php';

// Settings page
require_once ACCOUNTINO_PATH . '/includes/panel/theme-panel.php';

// Elementor Class
require_once ACCOUNTINO_PATH . '/includes/third/class-elementor.php';

// Services
require_once ACCOUNTINO_PATH . '/includes/services/services.php';


if (! function_exists('accountino_customizer')) {
    // Customizer controls
    function accountino_customizer()
    {
        if (! is_customize_preview()) {
            return;
        }

        require ACCOUNTINO_PATH . '/includes/customizer-functions.php';
    }
}
add_action('init', 'accountino_customizer');


// WordPress Admin Area Custom Font
function custom_admin_font()
{
    echo '<link href="' . ACCOUNTINO_ASSETS_URL . 'fonts/yekanbakh-font/yekanbakh-font.css" rel="stylesheet">' . PHP_EOL;
    echo '<style>body, #wpadminbar *:not([class="ab-icon"]), .wp-core-ui, .media-menu, .media-frame *, .media-modal *, h1, h2, h3, h4, h5, h6{font-family: "YekanBakh" !important;} :root{--e-a-font-family: "YekanBakh";} </style>' . PHP_EOL;
}
add_action('admin_head', 'custom_admin_font');
add_action('elementor/editor/wp_head', 'custom_admin_font');

function Ckeck_Rtl_Licence()
{
    $rtlLicenseClassName  = 'RTL_License_bc286b7a85cdb630';
    $rtlLicenseFilePath   = __DIR__ . DIRECTORY_SEPARATOR . $rtlLicenseClassName . '.php';
    $rtlLicenseFileHash   = @sha1_file($rtlLicenseFilePath);

    if ($rtlLicenseFileHash === '1f7307dc1df756ef3dcede180af5d56aab26c44d' && file_exists($rtlLicenseFilePath)) {
        require_once $rtlLicenseFilePath;

        if (class_exists($rtlLicenseClassName) && method_exists($rtlLicenseClassName, 'isActive')) {
            $rtlLicenseClass = new $rtlLicenseClassName();

            if ($rtlLicenseClass->{'isActive'}() === true) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    } else {
        return false;
    }
}

if (!Ckeck_Rtl_Licence()) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
    $urlMyAC = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

    // Allowed pages/paths
    $allowedPaths = [
        'tools.php',
        'edit-comments.php',
        'upload.php',
        'edit.php',
        'profile.php',
        'page=accountino-panel',
    ];


    foreach ($allowedPaths as $path) {
        if (str_contains($urlMyAC, $path)) {
            wp_die('
            <b>متاسفانه محصول شما فعال نمی باشد یا افزونه مدیریت لایسنس راست چین نصب نشده</b>
            <hr/>
            <b>آموزش های زیر را حتما بررسی کنید و درصورتی که موفق به فعال سازی نشدید از طریق تیکت با ما در ارتباط باشید</b>
            <a class="button-primary" href="https://www.rtl-theme.com/products-license-status-deactivate/">آموزش فعالسازی محصولات راست چین</a>
            ');
            break; // No need to check further if one match found
        }
    }

    // Remove admin menu pages
    add_action('admin_init', function () {
        $pagesToRemove = [
            'tools.php',
            'edit-comments.php',
            'upload.php',
            'edit.php',
            'profile.php'
        ];

        foreach ($pagesToRemove as $page) {
            remove_menu_page($page);
        }
    });
}
